/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import java.util.Collection;
import org.apache.cayenne.configuration.BaseConfigurationNodeVisitor;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.modeler.util.CodeValidationUtil;
import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.SimpleValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

class CgenValidator {
    CgenValidator() {
    }

    ValidationResult getValidationResult(Collection<? extends ConfigurationNode> classes) {
        final ValidationResult validationResult = new ValidationResult();
        for (ConfigurationNode configurationNode : classes) {
            configurationNode.acceptVisitor(new BaseConfigurationNodeVisitor<Void>(){

                @Override
                public Void visitObjEntity(ObjEntity entity) {
                    CgenValidator.this.validateEntity(validationResult, entity);
                    return null;
                }

                @Override
                public Void visitEmbeddable(Embeddable embeddable) {
                    CgenValidator.this.validateEmbeddable(validationResult, embeddable);
                    return null;
                }

                @Override
                public Void visitDataMap(DataMap dataMap) {
                    return null;
                }
            });
        }
        return validationResult;
    }

    private ValidationFailure validateEmbeddableAttribute(EmbeddableAttribute attribute) {
        return this.validateAttribute(attribute.getEmbeddable().getClassName(), attribute.getName(), attribute.getType());
    }

    private ValidationFailure validateAttribute(String objectName, String attributeName, String attributeType) {
        ValidationFailure emptyName = BeanValidationFailure.validateNotEmpty((Object)objectName, "attribute.name", attributeName);
        if (emptyName != null) {
            return emptyName;
        }
        ValidationFailure badName = CodeValidationUtil.validateJavaIdentifier(objectName, "attribute.name", attributeName);
        if (badName != null) {
            return badName;
        }
        ValidationFailure emptyType = BeanValidationFailure.validateNotEmpty((Object)objectName, "attribute.type", attributeType);
        if (emptyType != null) {
            return emptyType;
        }
        return BeanValidationFailure.validateJavaClassName(objectName, "attribute.type", attributeType);
    }

    private ValidationFailure validateEmbeddable(Embeddable embeddable) {
        String name = embeddable.getClassName();
        ValidationFailure emptyClass = BeanValidationFailure.validateNotEmpty((Object)name, "className", embeddable.getClassName());
        if (emptyClass != null) {
            return emptyClass;
        }
        return BeanValidationFailure.validateJavaClassName(name, "className", embeddable.getClassName());
    }

    private void validateEntity(ValidationResult validationBuffer, ObjEntity entity) {
        ValidationFailure failure;
        ValidationFailure entityFailure = this.validateEntity(entity);
        if (entityFailure != null) {
            validationBuffer.addFailure(entityFailure);
            return;
        }
        for (ObjAttribute attribute : entity.getAttributes()) {
            if (attribute instanceof EmbeddedAttribute) {
                EmbeddedAttribute embeddedAttribute = (EmbeddedAttribute)attribute;
                for (ObjAttribute subAttribute : embeddedAttribute.getAttributes()) {
                    ValidationFailure failure2 = this.validateEmbeddedAttribute(subAttribute);
                    if (failure2 == null) continue;
                    validationBuffer.addFailure(failure2);
                    return;
                }
                continue;
            }
            failure = this.validateAttribute(attribute);
            if (failure == null) continue;
            validationBuffer.addFailure(failure);
            return;
        }
        for (ObjRelationship rel : entity.getRelationships()) {
            failure = this.validateRelationship(rel);
            if (failure == null) continue;
            validationBuffer.addFailure(failure);
            return;
        }
    }

    private ValidationFailure validateEntity(ObjEntity entity) {
        String name = entity.getName();
        if (entity.isGeneric()) {
            return new SimpleValidationFailure(name, "Generic class");
        }
        ValidationFailure emptyClass = BeanValidationFailure.validateNotEmpty((Object)name, "className", entity.getClassName());
        if (emptyClass != null) {
            return emptyClass;
        }
        ValidationFailure badClass = BeanValidationFailure.validateJavaClassName(name, "className", entity.getClassName());
        if (badClass != null) {
            return badClass;
        }
        if (entity.getSuperClassName() != null) {
            return BeanValidationFailure.validateJavaClassName(name, "superClassName", entity.getSuperClassName());
        }
        return null;
    }

    private ValidationFailure validateAttribute(ObjAttribute attribute) {
        return this.validateAttribute(attribute.getEntity().getName(), attribute.getName(), attribute.getType());
    }

    private ValidationFailure validateEmbeddedAttribute(ObjAttribute attribute) {
        String name = attribute.getEntity().getName();
        String[] attributes = attribute.getName().split("\\.");
        String nameEmbeddedAttribute = attributes[0];
        int beginIndex = attributes[0].length();
        String attr = attribute.getName().substring(beginIndex + 1);
        ValidationFailure emptyEmbeddedName = BeanValidationFailure.validateNotEmpty((Object)name, "attribute.name", nameEmbeddedAttribute);
        if (emptyEmbeddedName != null) {
            return emptyEmbeddedName;
        }
        ValidationFailure badEmbeddedName = CodeValidationUtil.validateJavaIdentifier(name, "attribute.name", nameEmbeddedAttribute);
        if (badEmbeddedName != null) {
            return badEmbeddedName;
        }
        return this.validateAttribute(name, attr, attribute.getType());
    }

    private ValidationFailure validateRelationship(ObjRelationship relationship) {
        String name = relationship.getSourceEntity().getName();
        ValidationFailure emptyName = BeanValidationFailure.validateNotEmpty((Object)name, "relationship.name", relationship.getName());
        if (emptyName != null) {
            return emptyName;
        }
        ValidationFailure badName = CodeValidationUtil.validateJavaIdentifier(name, "relationship.name", relationship.getName());
        if (badName != null) {
            return badName;
        }
        if (!relationship.isToMany()) {
            ObjEntity targetEntity = relationship.getTargetEntity();
            if (targetEntity == null) {
                return new BeanValidationFailure(name, "relationship.targetEntity", "No target entity");
            }
            if (!targetEntity.isGeneric()) {
                ValidationFailure emptyClass = BeanValidationFailure.validateNotEmpty((Object)name, "relationship.targetEntity.className", targetEntity.getClassName());
                if (emptyClass != null) {
                    return emptyClass;
                }
                return BeanValidationFailure.validateJavaClassName(name, "relationship.targetEntity.className", targetEntity.getClassName());
            }
        }
        return null;
    }

    private void validateEmbeddable(ValidationResult validationBuffer, Embeddable embeddable) {
        ValidationFailure embeddableFailure = this.validateEmbeddable(embeddable);
        if (embeddableFailure != null) {
            validationBuffer.addFailure(embeddableFailure);
            return;
        }
        for (EmbeddableAttribute attribute : embeddable.getAttributes()) {
            ValidationFailure failure = this.validateEmbeddableAttribute(attribute);
            if (failure == null) continue;
            validationBuffer.addFailure(failure);
            return;
        }
    }
}

