/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen.domain;

import java.nio.file.Paths;
import java.util.Set;
import java.util.prefs.Preferences;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.gen.CgenConfigList;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClassGenerationActionFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.pref.GeneralPreferences;
import org.apache.cayenne.modeler.editor.GeneratorsTabController;
import org.apache.cayenne.modeler.editor.cgen.domain.CgenTab;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.tools.ToolsInjectorBuilder;

public class CgenTabController
extends GeneratorsTabController<CgenConfiguration> {
    public CgenTabController(ProjectController projectController) {
        super(projectController, CgenConfiguration.class, true);
        this.view = new CgenTab(projectController, this);
    }

    @Override
    public void runGenerators(Set<DataMap> dataMaps) {
        DataChannelMetaData metaData = Application.getInstance().getMetaData();
        if (dataMaps.isEmpty()) {
            this.view.showEmptyMessage();
            return;
        }
        boolean generationFail = false;
        ClassGenerationActionFactory actionFactory = new ToolsInjectorBuilder().addModule(binder -> binder.bind(DataChannelMetaData.class).toInstance(metaData)).create().getInstance(ClassGenerationActionFactory.class);
        for (DataMap dataMap : dataMaps) {
            try {
                CgenConfigList cgenConfigList = metaData.get(dataMap, CgenConfigList.class);
                if (cgenConfigList == null) {
                    cgenConfigList = new CgenConfigList();
                    cgenConfigList.add(this.createConfiguration(dataMap));
                }
                for (CgenConfiguration cgenConfiguration : cgenConfigList.getAll()) {
                    cgenConfiguration.setForce(true);
                    ClassGenerationAction action = actionFactory.createAction(cgenConfiguration);
                    action.prepareArtifacts();
                    action.execute();
                }
            }
            catch (CayenneRuntimeException e) {
                LOGGER.error("Error generating classes", e);
                generationFail = true;
                ((CgenTab)this.view).showErrorMessage(e.getUnlabeledMessage());
            }
            catch (Exception e) {
                LOGGER.error("Error generating classes", e);
                generationFail = true;
                ((CgenTab)this.view).showErrorMessage(e.getMessage());
            }
        }
        if (!generationFail) {
            ((CgenTab)this.view).showSuccessMessage();
        }
    }

    public CgenConfiguration createConfiguration(DataMap dataMap) {
        CgenConfiguration cgenConfiguration = new CgenConfiguration();
        cgenConfiguration.setDataMap(dataMap);
        cgenConfiguration.updateOutputPath(Paths.get(ModelerUtil.initOutputFolder(), new String[0]));
        Preferences preferences = Application.getInstance().getPreferencesNode(GeneralPreferences.class, "");
        if (preferences != null) {
            cgenConfiguration.setEncoding(preferences.get("encoding", null));
        }
        cgenConfiguration.resolveExcludedEntities();
        cgenConfiguration.resolveExcludedEmbeddables();
        return cgenConfiguration;
    }

    @Override
    public void showConfig(DataMap dataMap) {
        if (dataMap != null) {
            DataMapDisplayEvent event = new DataMapDisplayEvent((Object)this.getView(), dataMap, dataMap.getDataChannelDescriptor());
            this.getProjectController().fireDataMapDisplayEvent(event);
        }
    }
}

