/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.dbsync.reverse.dbimport.SchemaContainer;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.tree.NodeType;

public class DbImportSorter {
    public static final Comparator<DbImportTreeNode> NODE_COMPARATOR_BY_TYPE = Comparator.comparing(DbImportTreeNode::getNodeType);
    public static final Comparator<DbImportTreeNode> NODE_COMPARATOR_BY_TYPE_BY_NAME = Comparator.comparing(DbImportTreeNode::getNodeType).thenComparing(DbImportTreeNode::getSimpleNodeName);

    public static void sortSingleNode(DbImportTreeNode node, Comparator<DbImportTreeNode> comparator) {
        DbImportSorter.sortNodeItems(node, comparator);
        DbImportSorter.syncUserObjectItems(node);
    }

    public static void sortSubtree(DbImportTreeNode root, Comparator<DbImportTreeNode> comparator) {
        DbImportSorter.sortSingleNode(root, comparator);
        root.getChildNodes().forEach(r -> DbImportSorter.sortSubtree(r, comparator));
    }

    private static void sortNodeItems(DbImportTreeNode node, Comparator<DbImportTreeNode> comparator) {
        List<DbImportTreeNode> childNodes = node.getChildNodes();
        node.removeAllChildren();
        childNodes.sort(comparator);
        childNodes.forEach(node::add);
    }

    public static void syncUserObjectItems(DbImportTreeNode parentNode) {
        Object userObject = parentNode.getUserObject();
        if (parentNode.isReverseEngineering()) {
            DbImportSorter.syncCatalogs(parentNode, (ReverseEngineering)userObject);
            DbImportSorter.syncSchemas(parentNode, (ReverseEngineering)userObject);
            DbImportSorter.syncPatternParamsInContainer(parentNode, (ReverseEngineering)userObject);
        }
        if (parentNode.isCatalog()) {
            DbImportSorter.syncSchemas(parentNode, (Catalog)userObject);
            DbImportSorter.syncPatternParamsInContainer(parentNode, (Catalog)userObject);
        }
        if (parentNode.isSchema()) {
            DbImportSorter.syncPatternParamsInContainer(parentNode, (Schema)userObject);
        }
        if (parentNode.isIncludeTable()) {
            DbImportSorter.syncTablesColumns(parentNode, (IncludeTable)userObject);
        }
    }

    private static void syncCatalogs(DbImportTreeNode node, ReverseEngineering reverseEngineering) {
        DbImportSorter.syncPatternParams(reverseEngineering.getCatalogs(), node, NodeType.CATALOG);
    }

    private static void syncSchemas(DbImportTreeNode node, SchemaContainer schemaContainer) {
        DbImportSorter.syncPatternParams(schemaContainer.getSchemas(), node, NodeType.SCHEMA);
    }

    private static void syncPatternParamsInContainer(DbImportTreeNode node, FilterContainer container) {
        DbImportSorter.syncPatternParams(container.getIncludeTables(), node, NodeType.INCLUDE_TABLE);
        DbImportSorter.syncPatternParams(container.getExcludeTables(), node, NodeType.EXCLUDE_TABLE);
        DbImportSorter.syncPatternParams(container.getIncludeColumns(), node, NodeType.INCLUDE_COLUMN);
        DbImportSorter.syncPatternParams(container.getExcludeColumns(), node, NodeType.EXCLUDE_COLUMN);
        DbImportSorter.syncPatternParams(container.getIncludeProcedures(), node, NodeType.INCLUDE_PROCEDURE);
        DbImportSorter.syncPatternParams(container.getExcludeProcedures(), node, NodeType.EXCLUDE_PROCEDURE);
    }

    private static void syncTablesColumns(DbImportTreeNode node, IncludeTable table) {
        DbImportSorter.syncPatternParams(table.getIncludeColumns(), node, NodeType.INCLUDE_COLUMN);
        DbImportSorter.syncPatternParams(table.getExcludeColumns(), node, NodeType.EXCLUDE_COLUMN);
    }

    private static <T> void syncPatternParams(Collection<T> collection, DbImportTreeNode node, NodeType type) {
        collection.clear();
        collection.addAll(node.getChildrenObjectsByType(type));
    }
}

