/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.validation.extension;

import java.util.EnumSet;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.project.extension.BaseSaverDelegate;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;

public class ValidationSaverDelegate
extends BaseSaverDelegate {
    private final DataChannelMetaData metaData;

    ValidationSaverDelegate(DataChannelMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public Void visitDataChannelDescriptor(DataChannelDescriptor channelDescriptor) {
        return this.printValidationConfig(channelDescriptor);
    }

    private Void printValidationConfig(DataChannelDescriptor dataChannelDescriptor) {
        ValidationConfig validationConfig = ValidationConfig.fromMetadata(this.metaData, dataChannelDescriptor);
        EnumSet<Inspection> disabledInspections = EnumSet.allOf(Inspection.class);
        disabledInspections.removeAll(validationConfig.getEnabledInspections());
        if (disabledInspections.isEmpty()) {
            return null;
        }
        this.encoder.start("validation").attribute("xmlns", "http://cayenne.apache.org/schema/11/validation");
        for (Inspection inspection : disabledInspections) {
            this.encoder.simpleTag("exclude", inspection.name());
        }
        this.encoder.end();
        return null;
    }
}

