/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.pref;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.pref.CayennePreference;
import org.apache.cayenne.pref.ChildrenMapPreference;

public class CayenneProjectPreferences {
    private Map<Class<?>, ChildrenMapPreference> cayennePreferences = new HashMap();
    private Map<Preferences, CayennePreference> projectCayennePreferences;

    public CayenneProjectPreferences() {
        this.cayennePreferences.put(DBConnectionInfo.class, new ChildrenMapPreference(new DBConnectionInfo()));
        this.projectCayennePreferences = new HashMap<Preferences, CayennePreference>();
        for (ChildrenMapPreference value : this.cayennePreferences.values()) {
            value.initChildrenPreferences();
        }
    }

    public ChildrenMapPreference getDetailObject(Class<?> className) {
        return this.cayennePreferences.get(className);
    }

    public CayennePreference getProjectDetailObject(Class<? extends CayennePreference> objectClass, Preferences preferences) {
        CayennePreference preference = this.projectCayennePreferences.get(preferences);
        if (preference == null) {
            try {
                Constructor<? extends CayennePreference> ct = objectClass.getConstructor(Preferences.class);
                preference = ct.newInstance(preferences);
                this.projectCayennePreferences.put(preferences, preference);
            }
            catch (Throwable e) {
                throw new CayenneRuntimeException("Error initializing preferences", e, new Object[0]);
            }
        }
        return preference;
    }

    public void removeProjectDetailObject(Preferences preference) {
        try {
            preference.removeNode();
            this.projectCayennePreferences.remove(preference);
        }
        catch (BackingStoreException e) {
            throw new CayenneRuntimeException("Error delete preferences", (Throwable)e, new Object[0]);
        }
    }
}

