/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.function.Supplier;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class ProcedureParameterValidator
extends ConfigurationNodeValidator<ProcedureParameter> {
    public ProcedureParameterValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(ProcedureParameter node, ValidationResult validationResult) {
        this.on(node, validationResult).performIfEnabled(Inspection.PROCEDURE_PARAMETER_NO_NAME, this::checkForName).performIfEnabled(Inspection.PROCEDURE_PARAMETER_NO_TYPE, this::checkForType).performIfEnabled(Inspection.PROCEDURE_PARAMETER_NO_LENGTH, this::checkForLength).performIfEnabled(Inspection.PROCEDURE_PARAMETER_NO_DIRECTION, this::checkForDirection);
    }

    private void checkForName(ProcedureParameter parameter, ValidationResult validationResult) {
        if (Util.isEmptyString(parameter.getName())) {
            this.addFailure(validationResult, parameter, "Unnamed ProcedureParameter", new Object[0]);
        }
    }

    private void checkForType(ProcedureParameter parameter, ValidationResult validationResult) {
        if (parameter.getType() == Integer.MAX_VALUE) {
            this.addFailure(validationResult, parameter, "ProcedureParameter '%s' has no type", parameter.getName());
        }
    }

    private void checkForLength(ProcedureParameter parameter, ValidationResult validationResult) {
        if (parameter.getMaxLength() < 0 && (parameter.getType() == 12 || parameter.getType() == -9 || parameter.getType() == 1 || parameter.getType() == -15)) {
            this.addFailure(validationResult, parameter, "Character ProcedureParameter '%s' doesn't have max length", parameter.getName());
        }
    }

    private void checkForDirection(ProcedureParameter parameter, ValidationResult validationResult) {
        if (parameter.getDirection() <= 0) {
            this.addFailure(validationResult, parameter, "ProcedureParameter '%s' has no direction", parameter.getName());
        }
    }
}

