/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.apache.cayenne.modeler.dialog.validator.ValidatorDialog;
import org.apache.cayenne.modeler.undo.JComboBoxUndoListener;
import org.apache.cayenne.swing.BindingBase;
import org.apache.cayenne.validation.ValidationException;

public class ComboSelectionBinding
extends BindingBase {
    protected JComboBox comboBox;
    protected Color defaultBGColor;
    protected Color errorColor;
    protected String defaultToolTip;
    protected String noSelectionValue;

    public ComboSelectionBinding(JComboBox comboBox, String expression, String noSelectionValue) {
        super(expression);
        this.comboBox = comboBox;
        this.noSelectionValue = noSelectionValue;
        if (noSelectionValue != null && (comboBox.getItemCount() == 0 || comboBox.getItemAt(0) != noSelectionValue)) {
            comboBox.insertItemAt(noSelectionValue, 0);
        }
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ComboSelectionBinding.this.modelUpdateDisabled) {
                    ComboSelectionBinding.this.updateModel();
                }
            }
        });
        this.initComponentDefaults();
    }

    protected void initComponentDefaults() {
        Component editor;
        this.errorColor = ValidatorDialog.WARNING_COLOR;
        if (this.comboBox.getEditor() != null && (editor = this.comboBox.getEditor().getEditorComponent()) instanceof JComponent) {
            JComponent jEditor = (JComponent)editor;
            this.defaultBGColor = jEditor.getBackground();
            this.defaultToolTip = jEditor.getToolTipText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateView() {
        Object value = this.getValue();
        this.modelUpdateDisabled = true;
        try {
            ItemListener[] listeners;
            this.clear();
            for (ItemListener itemListener : listeners = this.comboBox.getItemListeners()) {
                if (!(itemListener instanceof JComboBoxUndoListener)) continue;
                ((JComboBoxUndoListener)itemListener).setIsUserAction(false);
            }
            if (value != null) {
                this.comboBox.setSelectedItem(value.toString());
            } else if (this.noSelectionValue != null) {
                this.comboBox.setSelectedItem(this.noSelectionValue);
            } else {
                this.comboBox.setSelectedIndex(-1);
            }
        }
        finally {
            this.modelUpdateDisabled = false;
        }
    }

    protected void updateModel() {
        try {
            Object value = this.comboBox.getSelectedItem();
            if (this.noSelectionValue != null && this.noSelectionValue.equals(value)) {
                value = null;
            }
            this.setValue(value);
            this.clear();
        }
        catch (ValidationException vex) {
            this.initWarning(vex.getLocalizedMessage());
        }
    }

    @Override
    public Component getView() {
        return this.comboBox;
    }

    protected void clear() {
        Component editor;
        if (this.comboBox.getEditor() != null && (editor = this.comboBox.getEditor().getEditorComponent()) instanceof JComponent) {
            JComponent jEditor = (JComponent)editor;
            jEditor.setBackground(this.defaultBGColor);
            jEditor.setToolTipText(this.defaultToolTip);
        }
    }

    protected void initWarning(String message) {
        Component editor;
        if (this.comboBox.getEditor() != null && (editor = this.comboBox.getEditor().getEditorComponent()) instanceof JComponent) {
            JComponent jEditor = (JComponent)editor;
            jEditor.setBackground(this.errorColor);
            jEditor.setToolTipText(message);
        }
    }
}

