/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Fault;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

class DataContextSnapshotBuilder
implements PropertyVisitor {
    private final EntityResolver resolver;
    private final ObjectStore objectStore;
    private final Persistent object;
    private DataRow snapshot;

    DataContextSnapshotBuilder(EntityResolver resolver, ObjectStore objectStore, Persistent object) {
        this.resolver = resolver;
        this.objectStore = objectStore;
        this.object = object;
    }

    public DataRow build() {
        if (this.object.getPersistenceState() == 5 && this.object.getObjectContext() != null) {
            return this.objectStore.getSnapshot(this.object.getObjectId());
        }
        ObjEntity entity = this.resolver.getObjEntity(this.object);
        ClassDescriptor descriptor = this.resolver.getClassDescriptor(entity.getName());
        this.snapshot = new DataRow(10);
        this.snapshot.setEntityName(entity.getName());
        descriptor.visitProperties(this);
        Map<String, Object> thisIdParts = this.object.getObjectId().getIdSnapshot();
        if (thisIdParts != null) {
            for (Map.Entry<String, Object> entry : thisIdParts.entrySet()) {
                String nextKey = entry.getKey();
                if (this.snapshot.containsKey(nextKey)) continue;
                this.snapshot.put(nextKey, entry.getValue());
            }
        }
        return this.snapshot;
    }

    @Override
    public boolean visitAttribute(AttributeProperty property) {
        ObjAttribute objAttr = property.getAttribute();
        this.snapshot.put(objAttr.getDbAttributePath().value(), property.readPropertyDirectly(this.object));
        return true;
    }

    @Override
    public boolean visitToMany(ToManyProperty property) {
        return true;
    }

    @Override
    public boolean visitToOne(ToOneProperty property) {
        ObjRelationship rel = property.getRelationship();
        if (rel.isSourceIndependentFromTargetChange()) {
            return true;
        }
        Object targetObject = property.readPropertyDirectly(this.object);
        if (targetObject == null) {
            return true;
        }
        if (targetObject instanceof Fault) {
            DataRow storedSnapshot = this.objectStore.getSnapshot(this.object.getObjectId());
            if (storedSnapshot == null) {
                throw new CayenneRuntimeException("No matching objects found for ObjectId %s. Object may have been deleted externally.", this.object.getObjectId());
            }
            DbRelationship dbRel = rel.getDbRelationships().get(0);
            for (DbJoin join : dbRel.getJoins()) {
                String key = join.getSourceName();
                this.snapshot.put(key, storedSnapshot.get(key));
            }
            return true;
        }
        Persistent target = (Persistent)targetObject;
        Map<String, Object> idParts = target.getObjectId().getIdSnapshot();
        if (idParts.isEmpty()) {
            return true;
        }
        DbRelationship dbRel = rel.getDbRelationships().get(0);
        Map<String, Object> fk = dbRel.srcFkSnapshotWithTargetSnapshot(idParts);
        this.snapshot.putAll(fk);
        return true;
    }
}

