/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class DataChannelDescriptor
implements ConfigurationNode,
Serializable,
XMLSerializable {
    private static final long serialVersionUID = 6567527544207035602L;
    public static final String SCHEMA_XSD = "http://cayenne.apache.org/schema/11/domain";
    public static final String SCHEMA_XSD_LOCATION = "https://cayenne.apache.org/schema/11/domain.xsd";
    protected String name;
    protected Map<String, String> properties = new HashMap<String, String>();
    protected Collection<DataMap> dataMaps = new ArrayList<DataMap>(5);
    protected Collection<DataNodeDescriptor> nodeDescriptors = new ArrayList<DataNodeDescriptor>(3);
    protected transient Resource configurationSource;
    protected String defaultNodeName;

    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("domain").attribute("xmlns", SCHEMA_XSD).attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", true).attribute("xsi:schemaLocation", "http://cayenne.apache.org/schema/11/domain https://cayenne.apache.org/schema/11/domain.xsd", true).projectVersion();
        if (!this.properties.isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>(this.properties.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                encoder.property(key, this.properties.get(key));
            }
        }
        if (!this.dataMaps.isEmpty()) {
            ArrayList<DataMap> maps = new ArrayList<DataMap>(this.dataMaps);
            Collections.sort(maps);
            for (DataMap dataMap : maps) {
                encoder.start("map").attribute("name", dataMap.getName().trim()).end();
            }
        }
        if (!this.nodeDescriptors.isEmpty()) {
            ArrayList<DataNodeDescriptor> nodes = new ArrayList<DataNodeDescriptor>(this.nodeDescriptors);
            Collections.sort(nodes);
            encoder.nested(nodes, delegate);
        }
        delegate.visitDataChannelDescriptor(this);
        encoder.end();
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitDataChannelDescriptor(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Collection<DataMap> getDataMaps() {
        return this.dataMaps;
    }

    public DataMap getDataMap(String name) {
        for (DataMap map : this.dataMaps) {
            if (!name.equals(map.getName())) continue;
            return map;
        }
        return null;
    }

    public Collection<DataNodeDescriptor> getNodeDescriptors() {
        return this.nodeDescriptors;
    }

    public DataNodeDescriptor getNodeDescriptor(String name) {
        for (DataNodeDescriptor node : this.nodeDescriptors) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    public Resource getConfigurationSource() {
        return this.configurationSource;
    }

    public void setConfigurationSource(Resource configurationSource) {
        this.configurationSource = configurationSource;
    }

    public String getDefaultNodeName() {
        return this.defaultNodeName;
    }

    public void setDefaultNodeName(String defaultDataNodeName) {
        this.defaultNodeName = defaultDataNodeName;
    }
}

