/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.firebird;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.cayenne.configuration.runtime.DbAdapterDetector;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.firebird.FirebirdAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;

public class FirebirdSniffer
implements DbAdapterDetector {
    protected AdhocObjectFactory objectFactory;

    public FirebirdSniffer(@Inject AdhocObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
        String dbName = md.getDatabaseProductName();
        if (dbName == null || !dbName.toUpperCase().contains("FIREBIRD")) {
            return null;
        }
        return (DbAdapter)this.objectFactory.newInstance(DbAdapter.class, FirebirdAdapter.class.getName());
    }
}

