/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.path;

import org.apache.cayenne.exp.path.CayennePathSegment;

class PathParser {
    private static final int INITIAL_SEGMENTS_COUNT = 4;
    private static final int MAX_SEGMENTS_COUNT = 10000;

    PathParser() {
    }

    static CayennePathSegment[] parseAllSegments(String path) {
        int next;
        int off = 0;
        int i = 0;
        CayennePathSegment[] result = null;
        while ((next = path.indexOf(46, off)) != -1) {
            if (off == next) {
                throw new IllegalArgumentException("Illegal path expression");
            }
            if (result == null) {
                result = new CayennePathSegment[4];
            }
            result[i++] = PathParser.parseSegment(path, off, next);
            if (i == result.length) {
                if (result.length > 10000) {
                    throw new IllegalArgumentException("Illegal path expression");
                }
                CayennePathSegment[] newList = new CayennePathSegment[result.length * 2];
                System.arraycopy(result, 0, newList, 0, result.length);
                result = newList;
            }
            off = next + 1;
        }
        if (off == 0) {
            return null;
        }
        if (off == path.length()) {
            throw new IllegalArgumentException("Illegal path expression");
        }
        result[i] = PathParser.parseSegment(path, off, path.length());
        return result;
    }

    static CayennePathSegment parseSegment(String segment, int start, int end) {
        if (segment.charAt(end - 1) == '+') {
            return new CayennePathSegment(segment.substring(start, end - 1), true);
        }
        return new CayennePathSegment(segment.substring(start, end), false);
    }

    static CayennePathSegment parseSegment(String segment) {
        boolean outer = false;
        if (segment.length() > 1 && segment.charAt(segment.length() - 1) == '+') {
            segment = segment.substring(0, segment.length() - 1);
            outer = true;
        }
        return new CayennePathSegment(segment, outer);
    }
}

