/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ExtendedEnumeration;
import org.apache.cayenne.reflect.Converter;
import org.apache.cayenne.util.Util;

class EnumConverter<T extends Enum<T>>
implements Converter<T> {
    EnumConverter() {
    }

    @Override
    public T convert(Object object, Class<T> type) {
        if (ExtendedEnumeration.class.isAssignableFrom(type)) {
            ExtendedEnumeration[] values;
            try {
                values = (ExtendedEnumeration[])type.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new CayenneRuntimeException(e);
            }
            for (ExtendedEnumeration en : values) {
                if (!Util.nullSafeEquals(en.getDatabaseValue(), object)) continue;
                return (T)((Enum)((Object)en));
            }
            return null;
        }
        if (object == null) {
            return null;
        }
        return Enum.valueOf(type, object.toString());
    }
}

