/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.AbstractNumberConverterTest;
import org.apache.commons.beanutils2.converters.LongConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LongConverterTest
extends AbstractNumberConverterTest<Long> {
    private Converter<Long> converter;

    @Override
    protected Class<Long> getExpectedType() {
        return Long.class;
    }

    protected LongConverter makeConverter() {
        return new LongConverter();
    }

    protected LongConverter makeConverter(Long defaultValue) {
        return new LongConverter(defaultValue);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = Long.valueOf("-12");
        this.numbers[1] = Long.valueOf("13");
        this.numbers[2] = Long.valueOf("-22");
        this.numbers[3] = Long.valueOf("23");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Long.MIN_VALUE), "-17", "-1", "0", "1", "17", String.valueOf(Long.MAX_VALUE), (byte)7, (short)8, 9, 10L, Float.valueOf(11.1f), 12.2};
        Long[] expected = new Long[]{Long.MIN_VALUE, -17L, -1L, 0L, 1L, 17L, Long.MAX_VALUE, 7L, 8L, 9L, 10L, 11L, 12L};
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Long)expected[i], (Long)((Long)this.converter.convert(Long.class, input[i])), (String)(message[i] + " to Long"));
            Assertions.assertEquals((Long)expected[i], (Long)((Long)this.converter.convert(Long.TYPE, input[i])), (String)(message[i] + " to long"));
            Assertions.assertEquals((Long)expected[i], (Long)((Long)this.converter.convert(null, input[i])), (String)(message[i] + " to null type"));
        }
    }
}

