/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc.mysql;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.JDBCDiskCacheFactory;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.TableState;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.dsfactory.DataSourceFactory;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.mysql.MySQLDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.mysql.MySQLDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.mysql.MySQLTableOptimizer;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.mysql.util.ScheduleParser;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class MySQLDiskCacheFactory
extends JDBCDiskCacheFactory {
    private static final Log log = LogManager.getLog(MySQLDiskCacheFactory.class);

    @Override
    public <K, V> MySQLDiskCache<K, V> createCache(AuxiliaryCacheAttributes rawAttr, ICompositeCacheManager compositeCacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) throws SQLException {
        MySQLDiskCacheAttributes cattr = (MySQLDiskCacheAttributes)rawAttr;
        TableState tableState = this.getTableState(cattr.getTableName());
        DataSourceFactory dsFactory = this.getDataSourceFactory(cattr, compositeCacheManager.getConfigurationProperties());
        MySQLDiskCache cache = new MySQLDiskCache(cattr, dsFactory, tableState);
        cache.setCacheEventLogger(cacheEventLogger);
        cache.setElementSerializer(elementSerializer);
        this.createShrinkerWhenNeeded(cattr, cache);
        this.scheduleOptimizations(cattr, tableState, cache.getDataSource());
        return cache;
    }

    protected void scheduleOptimizations(MySQLDiskCacheAttributes attributes, TableState tableState, DataSource ds) {
        if (attributes != null) {
            if (attributes.getOptimizationSchedule() != null) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = attributes::getTableName;
                supplierArray[1] = attributes::getOptimizationSchedule;
                log.info("Will try to configure optimization for table [{0}] on schedule [{1}]", supplierArray);
                MySQLTableOptimizer optimizer = new MySQLTableOptimizer(attributes, tableState, ds);
                try {
                    Date[] dates;
                    for (Date date : dates = ScheduleParser.createDatesForSchedule(attributes.getOptimizationSchedule())) {
                        this.scheduleOptimization(date, optimizer);
                    }
                }
                catch (ParseException e) {
                    log.warn("Problem creating optimization schedule for table [{0}]", attributes.getTableName(), e);
                }
            } else {
                log.info("Optimization is not configured for table [{0}]", attributes.getTableName());
            }
        }
    }

    protected void scheduleOptimization(Date startTime, MySQLTableOptimizer optimizer) {
        log.info("startTime [{0}] for optimizer {1}", startTime, optimizer);
        Date now = new Date();
        long initialDelay = startTime.getTime() - now.getTime();
        this.getScheduledExecutorService().scheduleAtFixedRate(() -> MySQLDiskCacheFactory.optimizeTable(optimizer), initialDelay, 86400L, TimeUnit.SECONDS);
    }

    private static void optimizeTable(MySQLTableOptimizer optimizer) {
        if (optimizer != null) {
            boolean success = optimizer.optimizeTable();
            log.info("Optimization success status [{0}]", success);
        } else {
            log.warn("OptimizerRunner: The optimizer is null. Could not optimize table.");
        }
    }
}

