/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class Issues300Test {
    @Test
    public void testIssue301a() throws Exception {
        JexlEngine jexl = new JexlBuilder().safe(false).arithmetic(new JexlArithmetic(false)).create();
        String[] srcs = new String[]{"var x = null; x.0", "var x = null; x[0]", "var x = [null,1]; x[0][0]"};
        for (int i = 0; i < srcs.length; ++i) {
            String src = srcs[i];
            JexlScript s = jexl.createScript(src);
            try {
                Object o = s.execute(null);
                if (i <= 0) continue;
                Assert.fail((String)(src + ": Should have failed"));
                continue;
            }
            catch (Exception ex) {
                Assert.assertTrue((boolean)ex.getMessage().contains("x"));
            }
        }
    }

    @Test
    public void testIssues301b() throws Exception {
        JexlEngine jexl = new JexlBuilder().safe(false).arithmetic(new JexlArithmetic(false)).create();
        Object[] xs = new Object[]{null, null, new Object[]{null, 1}};
        String[] srcs = new String[]{"x.0", "x[0]", "x[0][0]"};
        MapContext ctxt = new MapContext();
        for (int i = 0; i < xs.length; ++i) {
            ctxt.set("x", xs[i]);
            String src = srcs[i];
            JexlScript s = jexl.createScript(src);
            try {
                Object o = s.execute(null);
                Assert.fail((String)(src + ": Should have failed"));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testIssue302() throws Exception {
        MapContext jc = new MapContext();
        String[] strs = new String[]{"{if (0) 1 else 2; var x = 4;}", "if (0) 1; else 2; ", "{ if (0) 1; else 2; }", "{ if (0) { if (false) 1 else -3 } else 2; }"};
        JexlEngine jexl = new JexlBuilder().create();
        for (String str : strs) {
            JexlScript e = jexl.createScript(str);
            Object o = e.execute((JexlContext)jc);
            int oo = ((Number)o).intValue() % 2;
            Assert.assertEquals((String)("Block result is wrong " + str), (long)0L, (long)oo);
        }
    }

    @Test
    public void testIssue304() {
        JexlEngine jexlEngine = new JexlBuilder().strict(false).create();
        JexlExpression e304 = jexlEngine.createExpression("overview.limit.var");
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("var", "4711");
        HashMap<String, HashMap<String, String>> map2 = new HashMap<String, HashMap<String, String>>();
        map2.put("limit", map3);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("overview", map2);
        MapContext context = new MapContext(map);
        Object value = e304.evaluate((JexlContext)context);
        Assert.assertEquals((Object)"4711", (Object)value);
        map.clear();
        map.put("overview.limit.var", Integer.valueOf(42));
        value = e304.evaluate((JexlContext)context);
        Assert.assertEquals((Object)42, (Object)value);
        String allkw = "e304.if.else.do.while.new.true.false.null.var.function.empty.size.not.and.or.ne.eq.le.lt.gt.ge";
        map.put("e304.if.else.do.while.new.true.false.null.var.function.empty.size.not.and.or.ne.eq.le.lt.gt.ge", Integer.valueOf(42));
        e304 = jexlEngine.createExpression("e304.if.else.do.while.new.true.false.null.var.function.empty.size.not.and.or.ne.eq.le.lt.gt.ge");
        value = e304.evaluate((JexlContext)context);
        Assert.assertEquals((Object)42, (Object)value);
    }

    @Test
    public void testIssue305() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("{while(false) {}; var x = 1;}");
        String str0 = e.getParsedText();
        e = jexl.createScript(str0);
        Assert.assertNotNull((Object)e);
        String str1 = e.getParsedText();
        Assert.assertEquals((Object)str0, (Object)str1);
    }

    @Test
    public void testIssue306() throws Exception {
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("x.y ?: 2");
        Object o1 = e.execute(null);
        Assert.assertEquals((Object)2, (Object)o1);
        ctxt.set("x.y", null);
        Object o2 = e.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)2, (Object)o2);
    }

    @Test
    public void testIssue306a() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("x.y ?: 2", new String[]{"x"});
        Object o = e.execute(null, new Object[]{new Object()});
        Assert.assertEquals((Object)2, (Object)o);
        o = e.execute(null);
        Assert.assertEquals((Object)2, (Object)o);
    }

    @Test
    public void testIssue306b() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("x?.y ?: 2", new String[]{"x"});
        Object o1 = e.execute(null, new Object[]{new Object()});
        Assert.assertEquals((Object)2, (Object)o1);
        Object o2 = e.execute(null);
        Assert.assertEquals((Object)2, (Object)o2);
    }

    @Test
    public void testIssue306c() throws Exception {
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript e = jexl.createScript("x.y ?: 2", new String[]{"x"});
        Object o = e.execute(null, new Object[]{new Object()});
        Assert.assertEquals((Object)2, (Object)o);
        o = e.execute(null);
        Assert.assertEquals((Object)2, (Object)o);
    }

    @Test
    public void testIssue306d() throws Exception {
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript e = jexl.createScript("x.y[z.t] ?: 2", new String[]{"x"});
        Object o = e.execute(null, new Object[]{new Object()});
        Assert.assertEquals((Object)2, (Object)o);
        o = e.execute(null);
        Assert.assertEquals((Object)2, (Object)o);
    }

    @Test
    public void testIssue309a() throws Exception {
        String src = "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i = 12++;\n  </body>\n</html>";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JexlInfo info = new JexlInfo("template", 1, 1);
        try {
            JxltEngine.Template tmplt = jxlt.createTemplate(info, "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i = 12++;\n  </body>\n</html>");
            Assert.fail((String)"shoud have thrown exception");
        }
        catch (JexlException.Parsing xerror) {
            Assert.assertEquals((long)4L, (long)xerror.getInfo().getLine());
        }
    }

    @Test
    public void testIssue309b() throws Exception {
        String src = "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i = a b c;\n  </body>\n</html>";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JexlInfo info = new JexlInfo("template", 1, 1);
        try {
            JxltEngine.Template tmplt = jxlt.createTemplate(info, "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i = a b c;\n  </body>\n</html>");
            Assert.fail((String)"shoud have thrown exception");
        }
        catch (JexlException.Parsing xerror) {
            Assert.assertEquals((long)4L, (long)xerror.getInfo().getLine());
        }
    }

    @Test
    public void testIssue309c() throws Exception {
        String src = "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i =12;\n  </body>\n</html>";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JexlInfo info = new JexlInfo("template", 1, 1);
        try {
            JxltEngine.Template tmplt = jxlt.createTemplate(info, "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i =12;\n  </body>\n</html>");
            String src1 = tmplt.asString();
            String src2 = tmplt.toString();
            Assert.assertEquals((Object)src1, (Object)src2);
        }
        catch (JexlException.Parsing xerror) {
            Assert.assertEquals((long)4L, (long)xerror.getInfo().getLine());
        }
    }

    @Test
    public void test314() throws Exception {
        JexlEngine jexl = new JexlBuilder().strict(true).safe(false).create();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        VaContext ctxt = new VaContext(vars);
        JexlScript script = jexl.createScript("cell()");
        Object result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)0, (Object)result);
        script = jexl.createScript("x.cell()", new String[]{"x"});
        result = script.execute((JexlContext)ctxt, new Object[]{Arrays.asList(10, 20)});
        Assert.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("cell('1', '2')");
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)2, (Object)result);
        script = jexl.createScript("x.cell('1', '2')", new String[]{"x"});
        result = script.execute((JexlContext)ctxt, new Object[]{Arrays.asList(10, 20)});
        Assert.assertEquals((Object)44, (Object)result);
        vars.put("TVALOGAR", null);
        String jexlExp = "TVALOGAR==null?'SIMON':'SIMONAZO'";
        script = jexl.createScript(jexlExp);
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)"SIMON", (Object)result);
        jexlExp = "TVALOGAR.PEPITO==null?'SIMON':'SIMONAZO'";
        script = jexl.createScript(jexlExp);
        LinkedHashMap<String, Object> tva = new LinkedHashMap<String, Object>();
        tva.put("PEPITO", null);
        vars.put("TVALOGAR", tva);
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)"SIMON", (Object)result);
        vars.remove("TVALOGAR");
        ctxt.set("TVALOGAR.PEPITO", null);
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)"SIMON", (Object)result);
    }

    @Test
    public void test315() throws Exception {
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        VaContext ctxt = new VaContext(vars);
        JexlScript script = jexl.createScript("a?? 42 + 10", new String[]{"a"});
        Object result = script.execute((JexlContext)ctxt, new Object[]{32});
        Assert.assertEquals((Object)32, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assert.assertEquals((Object)52, (Object)result);
        script = jexl.createScript("- a??42 + +10", new String[]{"a"});
        result = script.execute((JexlContext)ctxt, new Object[]{32});
        Assert.assertEquals((Object)-32, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assert.assertEquals((Object)52, (Object)result);
        script = jexl.createScript("a? a : +42 + 10", new String[]{"a"});
        result = script.execute((JexlContext)ctxt, new Object[]{32});
        Assert.assertEquals((Object)32, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assert.assertEquals((Object)52, (Object)result);
        script = jexl.createScript("a ?: +42 + 10", new String[]{"a"});
        result = script.execute((JexlContext)ctxt, new Object[]{32});
        Assert.assertEquals((Object)32, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assert.assertEquals((Object)52, (Object)result);
    }

    @Test
    public void test317() throws Exception {
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        MapContext ctxt = new MapContext();
        JexlInfo info = new JexlInfo("test317", 1, 1);
        JexlScript script = jexl.createScript(info, "var f = ()-> {x + x }; f", new String[]{"x"});
        Object result = script.execute((JexlContext)ctxt, new Object[]{21});
        Assert.assertTrue((boolean)(result instanceof JexlScript));
        script = (JexlScript)result;
        info = JexlInfo.from((JexlScript)script);
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)"test317", (Object)info.getName());
        result = script.execute((JexlContext)ctxt, new Object[]{21});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void test322a() throws Exception {
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        MapContext context = new MapContext();
        String[] ins = new String[]{"${'{'}", "${\"{\"}", "${\"{}\"}", "${'{42}'}", "${\"{\\\"\\\"}\"}"};
        String[] ctls = new String[]{"{", "{", "{}", "{42}", "{\"\"}"};
        for (int i = 0; i < ins.length; ++i) {
            JxltEngine.Template template;
            String src = ins[i];
            try {
                template = jxlt.createTemplate("$$", (Reader)new StringReader(src), new String[0]);
            }
            catch (JexlException xany) {
                Assert.fail((String)src);
                throw xany;
            }
            StringWriter strw = new StringWriter();
            template.evaluate((JexlContext)context, (Writer)strw);
            String output = strw.toString();
            Assert.assertEquals((Object)ctls[i], (Object)output);
        }
    }

    @Test
    public void test322b() throws Exception {
        MapContext ctxt = new MapContext();
        String src = "L'utilisateur ${session.user.name} s'est connecte";
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JxltEngine.Template template = jxlt.createTemplate("$$", (Reader)new StringReader("L'utilisateur ${session.user.name} s'est connecte"), new String[0]);
        ctxt.set("session", (Object)new Session322());
        StringWriter strw = new StringWriter();
        template.evaluate((JexlContext)ctxt, (Writer)strw);
        String output = strw.toString();
        Assert.assertEquals((Object)"L'utilisateur user322 s'est connecte", (Object)output);
        ctxt.set("session.user", (Object)new User322());
        strw = new StringWriter();
        template.evaluate((JexlContext)ctxt, (Writer)strw);
        output = strw.toString();
        Assert.assertEquals((Object)"L'utilisateur user322 s'est connecte", (Object)output);
        ctxt.set("session.user.name", (Object)"user322");
        strw = new StringWriter();
        template.evaluate((JexlContext)ctxt, (Writer)strw);
        output = strw.toString();
        Assert.assertEquals((Object)"L'utilisateur user322 s'est connecte", (Object)output);
    }

    @Test
    public void test323() throws Exception {
        Object result;
        JexlScript script;
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        HashMap vars = new HashMap();
        MapContext jc = new MapContext(vars);
        try {
            script = jexl.createScript("a.n.t.variable");
            result = script.execute((JexlContext)jc);
            Assert.fail((String)"a.n.t.variable is undefined!");
        }
        catch (JexlException.Variable xvar) {
            Assert.assertTrue((boolean)xvar.toString().contains("a.n.t"));
        }
        jc.set("a.n.t.variable", null);
        script = jexl.createScript("a.n.t.variable");
        result = script.execute((JexlContext)jc);
        Assert.assertNull((Object)result);
        jc.set("a.n.t", null);
        try {
            script = jexl.createScript("a.n.t[0].variable");
            result = script.execute((JexlContext)jc);
            Assert.fail((String)"a.n.t is null!");
        }
        catch (JexlException.Variable xvar) {
            Assert.assertTrue((boolean)xvar.toString().contains("a.n.t"));
        }
        vars.remove("a.n.t");
        try {
            script = jexl.createScript("a.n.t[0].variable");
            result = script.execute((JexlContext)jc);
            Assert.fail((String)"a.n.t is undefined!");
        }
        catch (JexlException.Variable xvar) {
            Assert.assertTrue((boolean)xvar.toString().contains("a.n.t"));
        }
        ArrayList<Integer> inner = new ArrayList<Integer>();
        vars.put("a.n.t", inner);
        try {
            script = jexl.createScript("a.n.t[0].variable");
            result = script.execute((JexlContext)jc);
            Assert.fail((String)"a.n.t is null!");
        }
        catch (JexlException.Property xprop) {
            Assert.assertTrue((boolean)xprop.toString().contains("0"));
        }
        inner.add(42);
        try {
            script = jexl.createScript("a.n.t[0].variable");
            result = script.execute((JexlContext)jc);
            Assert.fail((String)"a.n.t is null!");
        }
        catch (JexlException.Property xprop) {
            Assert.assertTrue((boolean)xprop.toString().contains("variable"));
        }
    }

    @Test
    public void test324() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        String src42 = "new('java.lang.Integer', 42)";
        JexlExpression expr0 = jexl.createExpression("new('java.lang.Integer', 42)");
        Assert.assertEquals((Object)42, (Object)expr0.evaluate(null));
        String parsed = expr0.getParsedText();
        Assert.assertEquals((Object)"new('java.lang.Integer', 42)", (Object)parsed);
        try {
            JexlExpression expr = jexl.createExpression("new()");
            Assert.fail((String)"should not parse");
        }
        catch (JexlException.Parsing xparse) {
            Assert.assertTrue((boolean)xparse.toString().contains(")"));
        }
    }

    @Test
    public void test325() throws Exception {
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        HashMap<String, Object> map = new HashMap<String, Object>(){

            @Override
            public Object get(Object key) {
                return super.get(key == null ? "" : key);
            }

            @Override
            public Object put(String key, Object value) {
                return super.put(key == null ? "" : key, value);
            }
        };
        map.put("42", 42);
        MapContext jc = new MapContext();
        JexlScript script = jexl.createScript("map[null] = 42", new String[]{"map"});
        Object result = script.execute((JexlContext)jc, new Object[]{map});
        Assert.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("map[key]", new String[]{"map", "key"});
        result = script.execute((JexlContext)jc, new Object[]{map, null});
        Assert.assertEquals((Object)42, (Object)result);
        result = script.execute((JexlContext)jc, new Object[]{map, "42"});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void test330() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        String longExpression = "'THIS IS A VERY VERY VERY VERY VERY VERY VERY VERY VERY LONG STRING CONCATENATION ' + VARIABLE ' <--- error: missing + between VARIABLE and literal'";
        try {
            jexl.createExpression("'THIS IS A VERY VERY VERY VERY VERY VERY VERY VERY VERY LONG STRING CONCATENATION ' + VARIABLE ' <--- error: missing + between VARIABLE and literal'");
            Assert.fail((String)"parsing malformed expression did not throw exception");
        }
        catch (JexlException.Parsing exception) {
            Assert.assertTrue((boolean)exception.getMessage().contains("VARIABLE"));
        }
    }

    @Test
    public void test331() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext ctxt = new MapContext();
        JexlScript script = jexl.createScript("a + '\\n' + b", new String[]{"a", "b"});
        Object result = script.execute((JexlContext)ctxt, new Object[]{"hello", "world"});
        Assert.assertTrue((boolean)result.toString().contains("\n"));
    }

    @Test
    public void test347() throws Exception {
        String src = "A.B == 5";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript("A.B == 5");
        Object result = script.execute(null);
        Assert.assertFalse((boolean)((Boolean)result));
        jexl = new JexlBuilder().strict(true).safe(false).create();
        MapContext ctxt = new MapContext();
        script = jexl.createScript("A.B == 5");
        try {
            result = script.execute((JexlContext)ctxt);
            Assert.fail((String)"should only succeed with safe navigation");
        }
        catch (JexlException xany) {
            Assert.assertNotNull((Object)((Object)xany));
        }
        ctxt.set("A", null);
        try {
            result = script.execute((JexlContext)ctxt);
            Assert.fail((String)"should only succeed with safe navigation");
        }
        catch (JexlException xany) {
            Assert.assertNotNull((Object)((Object)xany));
        }
        ctxt.set("A.B", null);
        result = script.execute((JexlContext)ctxt);
        Assert.assertFalse((boolean)((Boolean)result));
    }

    @Test
    public void test349() throws Exception {
        String text = "(A ? C.D : E)";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlExpression expr = jexl.createExpression(text);
        JexlScript script = jexl.createScript(text);
    }

    public static class Session322 {
        public User322 getUser() {
            return new User322();
        }
    }

    public static class User322 {
        public String getName() {
            return "user322";
        }
    }

    public static class VaContext
    extends MapContext {
        VaContext(Map<String, Object> vars) {
            super(vars);
        }

        public int cell(String ... ms) {
            return ms.length;
        }

        public int cell(List<?> l, String ... ms) {
            return 42 + this.cell(ms);
        }
    }
}

