/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.neuralnet;

import java.util.function.DoubleUnaryOperator;
import org.apache.commons.math4.neuralnet.FeatureInitializer;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousUniformSampler;

public final class FeatureInitializerFactory {
    private FeatureInitializerFactory() {
    }

    public static FeatureInitializer uniform(UniformRandomProvider rng, double min, double max) {
        return FeatureInitializerFactory.randomize(new ContinuousUniformSampler(rng, min, max), FeatureInitializerFactory.function(x -> 0.0, 0.0, 0.0));
    }

    public static FeatureInitializer function(final DoubleUnaryOperator f, final double init, final double inc) {
        return new FeatureInitializer(){
            private double arg;
            {
                this.arg = init;
            }

            @Override
            public double value() {
                double result = f.applyAsDouble(this.arg);
                this.arg += inc;
                return result;
            }
        };
    }

    public static FeatureInitializer randomize(final ContinuousUniformSampler random, final FeatureInitializer orig) {
        return new FeatureInitializer(){

            @Override
            public double value() {
                return orig.value() + random.sample();
            }
        };
    }
}

