/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.function;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.analysis.ParametricUnivariateFunction;
import org.apache.commons.math4.legacy.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math4.legacy.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;

public class HarmonicOscillator
implements UnivariateDifferentiableFunction {
    private final double amplitude;
    private final double omega;
    private final double phase;

    public HarmonicOscillator(double amplitude, double omega, double phase) {
        this.amplitude = amplitude;
        this.omega = omega;
        this.phase = phase;
    }

    @Override
    public double value(double x) {
        return HarmonicOscillator.value(this.omega * x + this.phase, this.amplitude);
    }

    private static double value(double xTimesOmegaPlusPhase, double amplitude) {
        return amplitude * JdkMath.cos((double)xTimesOmegaPlusPhase);
    }

    @Override
    public DerivativeStructure value(DerivativeStructure t) throws DimensionMismatchException {
        double x = t.getValue();
        double[] f = new double[t.getOrder() + 1];
        double alpha = this.omega * x + this.phase;
        f[0] = this.amplitude * JdkMath.cos((double)alpha);
        if (f.length > 1) {
            f[1] = -this.amplitude * this.omega * JdkMath.sin((double)alpha);
            double mo2 = -this.omega * this.omega;
            for (int i = 2; i < f.length; ++i) {
                f[i] = mo2 * f[i - 2];
            }
        }
        return t.compose(f);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        @Override
        public double value(double x, double ... param) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(param);
            return HarmonicOscillator.value(x * param[1] + param[2], param[0]);
        }

        @Override
        public double[] gradient(double x, double ... param) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(param);
            double amplitude = param[0];
            double omega = param[1];
            double phase = param[2];
            double xTimesOmegaPlusPhase = omega * x + phase;
            double a = HarmonicOscillator.value(xTimesOmegaPlusPhase, 1.0);
            double p = -amplitude * JdkMath.sin((double)xTimesOmegaPlusPhase);
            double w = p * x;
            return new double[]{a, w, p};
        }

        private void validateParameters(double[] param) throws NullArgumentException, DimensionMismatchException {
            if (param == null) {
                throw new NullArgumentException();
            }
            if (param.length != 3) {
                throw new DimensionMismatchException(param.length, 3);
            }
        }
    }
}

