/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.arrays;

final class HashIndexSet {
    private static final String INVALID_INDEX = "Invalid index: ";
    private static final int MAX_CAPACITY = 0x20000000;
    private static final int MIN_SIZE = 16;
    private static final int PHI = -1640531527;
    private final int[] set;
    private int size;

    private HashIndexSet(int capacity) {
        this.set = new int[HashIndexSet.nextPow2(Math.max(16, capacity * 2))];
    }

    static HashIndexSet create(int capacity) {
        if (capacity > 0x20000000) {
            throw new IllegalArgumentException("Unsupported capacity: " + capacity);
        }
        return new HashIndexSet(capacity);
    }

    private static int nextPow2(int value) {
        int result = value - 1;
        result |= result >>> 1;
        result |= result >>> 2;
        result |= result >>> 4;
        result |= result >>> 8;
        return (result | result >>> 16) + 1;
    }

    boolean add(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(INVALID_INDEX + index);
        }
        int[] keys = this.set;
        int key = ~index;
        int mask = keys.length - 1;
        int pos = HashIndexSet.mix(index) & mask;
        int curr = keys[pos];
        if (curr < 0) {
            if (curr == key) {
                return false;
            }
            while ((curr = keys[pos = pos + 1 & mask]) < 0) {
                if (curr != key) continue;
                return false;
            }
        }
        keys[pos] = key;
        if (++this.size > mask + 1 >>> 1) {
            throw new IllegalStateException("Functional capacity exceeded: " + (keys.length >>> 1));
        }
        return true;
    }

    private static int mix(int x) {
        int h = x * -1640531527;
        return h ^ h >>> 16;
    }
}

