/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.statistics.descriptive.NaNPolicy;
import org.apache.commons.statistics.descriptive.NaNTransformer;

final class NaNTransformers {
    private NaNTransformers() {
    }

    static NaNTransformer createNaNTransformer(NaNPolicy nanPolicy, boolean copy) {
        if (nanPolicy == NaNPolicy.INCLUDE) {
            return new IncludeNaNTransformer(copy);
        }
        if (nanPolicy == NaNPolicy.EXCLUDE) {
            return new ExcludeNaNTransformer(copy);
        }
        return new ErrorNaNTransformer(copy);
    }

    static double[] copy(double[] data, int from, int to) {
        int length = to - from;
        double[] copy = new double[length];
        System.arraycopy(data, from, copy, 0, length);
        return copy;
    }

    private static final class ErrorNaNTransformer
    implements NaNTransformer {
        private final boolean copy;

        ErrorNaNTransformer(boolean copy) {
            this.copy = copy;
        }

        @Override
        public double[] apply(double[] data, int from, int to, int[] bounds) {
            double[] a = data;
            int i = to;
            while (--i >= from) {
                double v = a[i];
                if (v == v) continue;
                throw new IllegalArgumentException("NaN at " + i);
            }
            if (this.copy) {
                bounds[0] = 0;
                bounds[1] = to - from;
                return NaNTransformers.copy(data, from, to);
            }
            bounds[0] = from;
            bounds[1] = to;
            return data;
        }
    }

    private static final class ExcludeNaNTransformer
    implements NaNTransformer {
        private final boolean copy;

        ExcludeNaNTransformer(boolean copy) {
            this.copy = copy;
        }

        @Override
        public double[] apply(double[] data, int from, int to, int[] bounds) {
            int end;
            int start;
            double[] a;
            if (this.copy) {
                a = NaNTransformers.copy(data, from, to);
                start = 0;
                end = a.length;
            } else {
                a = data;
                start = from;
                end = to;
            }
            int i = end;
            while (--i >= start) {
                double v = a[i];
                if (v == v) continue;
                a[i] = a[--end];
                a[end] = v;
            }
            bounds[0] = start;
            bounds[1] = end;
            return a;
        }
    }

    private static final class IncludeNaNTransformer
    implements NaNTransformer {
        private final boolean copy;

        IncludeNaNTransformer(boolean copy) {
            this.copy = copy;
        }

        @Override
        public double[] apply(double[] data, int from, int to, int[] bounds) {
            if (this.copy) {
                bounds[0] = 0;
                bounds[1] = to - from;
                return NaNTransformers.copy(data, from, to);
            }
            bounds[0] = from;
            bounds[1] = to;
            return data;
        }
    }
}

