/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.tasks;

import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.Task;

public class VfsTask
extends Task {
    private static StandardFileSystemManager manager;

    protected void closeManager() {
        if (manager != null) {
            manager.close();
            manager = null;
        }
    }

    protected FileObject resolveFile(String uri) throws FileSystemException {
        if (manager == null) {
            StandardFileSystemManager mngr = new StandardFileSystemManager();
            mngr.setLogger((Log)new AntLogger());
            mngr.init();
            manager = mngr;
            this.getProject().addBuildListener((BuildListener)new CloseListener());
        }
        return manager.resolveFile(this.getProject().getBaseDir(), uri);
    }

    private final class AntLogger
    implements Log {
        private AntLogger() {
        }

        public void debug(Object o) {
            VfsTask.this.log(String.valueOf(o), 4);
        }

        public void debug(Object o, Throwable throwable) {
            this.debug(o);
        }

        public void error(Object o) {
            VfsTask.this.log(String.valueOf(o), 0);
        }

        public void error(Object o, Throwable throwable) {
            this.error(o);
        }

        public void fatal(Object o) {
            VfsTask.this.log(String.valueOf(o), 0);
        }

        public void fatal(Object o, Throwable throwable) {
            this.fatal(o);
        }

        public void info(Object o) {
            VfsTask.this.log(String.valueOf(o), 2);
        }

        public void info(Object o, Throwable throwable) {
            this.info(o);
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public boolean isErrorEnabled() {
            return true;
        }

        public boolean isFatalEnabled() {
            return true;
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public void trace(Object o) {
        }

        public void trace(Object o, Throwable throwable) {
        }

        public void warn(Object o) {
            VfsTask.this.log(String.valueOf(o), 1);
        }

        public void warn(Object o, Throwable throwable) {
            this.warn(o);
        }
    }

    private final class CloseListener
    implements SubBuildListener {
        private CloseListener() {
        }

        public void buildFinished(BuildEvent event) {
            VfsTask.this.closeManager();
        }

        public void buildStarted(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
        }

        public void subBuildFinished(BuildEvent buildEvent) {
            VfsTask.this.closeManager();
        }

        public void subBuildStarted(BuildEvent buildEvent) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }
    }
}

