/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Arrays;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.quantiles.DataToDoublesSketchUDAFTest;
import org.apache.datasketches.hive.quantiles.DoublesUnionState;
import org.apache.datasketches.hive.quantiles.UnionDoublesSketchUDAF;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionDoublesSketchUDAFTest {
    static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    static final ObjectInspector intInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT);
    static final ObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("a"), Arrays.asList(binaryInspector));

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorTooFewInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorTooManyInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongCategoryArg1() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{structInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongTypeArg1() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongCategoryArg2() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, structInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongTypeArg2() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test
    public void partia1ModelDefaultKDowsizeInput() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            DoublesUnionState state = (DoublesUnionState)eval.getNewAggregationBuffer();
            UpdateDoublesSketch sketch1 = DoublesSketch.builder().setK(256).build();
            sketch1.update(1.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.toByteArray())});
            UpdateDoublesSketch sketch2 = DoublesSketch.builder().setK(256).build();
            sketch2.update(2.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.toByteArray())});
            BytesWritable bytes = (BytesWritable)eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            DoublesSketch resultSketch = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((int)resultSketch.getK(), (int)128);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((double)resultSketch.getMinItem(), (double)1.0);
            Assert.assertEquals((double)resultSketch.getMaxItem(), (double)2.0);
        }
    }

    @Test
    public void partia1ModelGivenK() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            DoublesUnionState state = (DoublesUnionState)eval.getNewAggregationBuffer();
            UpdateDoublesSketch sketch1 = DoublesSketch.builder().setK(256).build();
            sketch1.update(1.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.toByteArray()), new IntWritable(256)});
            UpdateDoublesSketch sketch2 = DoublesSketch.builder().setK(256).build();
            sketch2.update(2.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.toByteArray()), new IntWritable(256)});
            BytesWritable bytes = (BytesWritable)eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            DoublesSketch resultSketch = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((int)resultSketch.getK(), (int)256);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((double)resultSketch.getMinItem(), (double)1.0);
            Assert.assertEquals((double)resultSketch.getMaxItem(), (double)2.0);
        }
    }

    @Test
    public void partial2Mode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL2, inspectors);
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            DoublesUnionState state = (DoublesUnionState)eval.getNewAggregationBuffer();
            UpdateDoublesSketch sketch1 = DoublesSketch.builder().setK(256).build();
            sketch1.update(1.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch1.toByteArray()));
            UpdateDoublesSketch sketch2 = DoublesSketch.builder().setK(256).build();
            sketch2.update(2.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch2.toByteArray()));
            BytesWritable bytes = (BytesWritable)eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            DoublesSketch resultSketch = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((int)resultSketch.getK(), (int)256);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((double)resultSketch.getMinItem(), (double)1.0);
            Assert.assertEquals((double)resultSketch.getMaxItem(), (double)2.0);
        }
    }

    @Test
    public void finalMode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.FINAL, inspectors);
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            DoublesUnionState state = (DoublesUnionState)eval.getNewAggregationBuffer();
            UpdateDoublesSketch sketch1 = DoublesSketch.builder().setK(256).build();
            sketch1.update(1.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch1.toByteArray()));
            UpdateDoublesSketch sketch2 = DoublesSketch.builder().setK(256).build();
            sketch2.update(2.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch2.toByteArray()));
            BytesWritable bytes = (BytesWritable)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            DoublesSketch resultSketch = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((int)resultSketch.getK(), (int)256);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((double)resultSketch.getMinItem(), (double)1.0);
            Assert.assertEquals((double)resultSketch.getMaxItem(), (double)2.0);
        }
    }

    @Test
    public void completeModelDefaultK() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            DoublesUnionState state = (DoublesUnionState)eval.getNewAggregationBuffer();
            UpdateDoublesSketch sketch1 = DoublesSketch.builder().build();
            sketch1.update(1.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.toByteArray())});
            UpdateDoublesSketch sketch2 = DoublesSketch.builder().build();
            sketch2.update(2.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.toByteArray())});
            BytesWritable bytes = (BytesWritable)eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            DoublesSketch resultSketch = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((int)resultSketch.getK(), (int)128);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((double)resultSketch.getMinItem(), (double)1.0);
            Assert.assertEquals((double)resultSketch.getMaxItem(), (double)2.0);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state));
        }
    }
}

