/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.datasketches.common.ArrayOfDoublesSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.sampling.SampleSubsetSummary;
import org.apache.datasketches.sampling.VarOptItemsSketch;
import org.apache.datasketches.sampling.VarOptItemsUnion;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VarOptCrossLanguageTest {
    static final double EPS = 1.0E-13;

    @Test(groups={"generate_java_files"})
    public void generateSketchesLong() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            VarOptItemsSketch sk = VarOptItemsSketch.newInstance((int)32);
            for (int i = 1; i <= n; ++i) {
                sk.update((Object)i, 1.0);
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("varopt_sketch_long_n" + n + "_java.sk"), new OpenOption[0]).write(sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe()));
        }
    }

    @Test(groups={"generate_java_files"})
    public void generateSketchStringExact() throws IOException {
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstance((int)1024);
        for (int i = 1; i <= 200; ++i) {
            sketch.update((Object)Integer.toString(i), 1000.0 / (double)i);
        }
        Files.newOutputStream(TestUtil.javaPath.resolve("varopt_sketch_string_exact_java.sk"), new OpenOption[0]).write(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()));
    }

    @Test(groups={"generate_java_files"})
    public void generateSketchLongSampling() throws IOException {
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstance((int)1024);
        for (long i = 0L; i < 2000L; ++i) {
            sketch.update((Object)i, 1.0);
        }
        sketch.update((Object)-1L, 100000.0);
        sketch.update((Object)-2L, 110000.0);
        sketch.update((Object)-3L, 120000.0);
        Files.newOutputStream(TestUtil.javaPath.resolve("varopt_sketch_long_sampling_java.sk"), new OpenOption[0]).write(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe()));
    }

    @Test(groups={"generate_java_files"})
    public void generateUnionDoubleSampling() throws IOException {
        int kSmall = 16;
        int n1 = 32;
        int n2 = 64;
        int kMax = 128;
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstance((int)16);
        for (int i = 0; i < 32; ++i) {
            sketch.update((Object)(1.0 * (double)i), 1.0);
        }
        sketch.update((Object)-1.0, 1024.0);
        VarOptItemsUnion union = VarOptItemsUnion.newInstance((int)128);
        union.update(sketch);
        sketch = VarOptItemsSketch.newInstance((int)16);
        for (int i = 0; i < 64; ++i) {
            sketch.update((Object)(1.0 * (double)i), 1.0);
        }
        union.update(sketch);
        Files.newOutputStream(TestUtil.javaPath.resolve("varopt_union_double_sampling_java.sk"), new OpenOption[0]).write(union.toByteArray((ArrayOfItemsSerDe)new ArrayOfDoublesSerDe()));
    }

    @Test(groups={"check_cpp_files"})
    public void deserializeFromCppSketchLongs() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("varopt_sketch_long_n" + n + "_cpp.sk"));
            VarOptItemsSketch sk = VarOptItemsSketch.heapify((MemorySegment)MemorySegment.ofArray(bytes), (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
            Assert.assertEquals((int)sk.getK(), (int)32);
            Assert.assertEquals((long)sk.getN(), (long)n);
            Assert.assertEquals((int)sk.getNumSamples(), (int)(n > 10 ? 32 : n));
        }
    }

    @Test(groups={"check_cpp_files"})
    public void deserializeFromCppSketchStringsExact() throws IOException {
        byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("varopt_sketch_string_exact_cpp.sk"));
        VarOptItemsSketch sk = VarOptItemsSketch.heapify((MemorySegment)MemorySegment.ofArray(bytes), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertEquals((int)sk.getK(), (int)1024);
        Assert.assertEquals((long)sk.getN(), (long)200L);
        Assert.assertEquals((int)sk.getNumSamples(), (int)200);
        SampleSubsetSummary ss = sk.estimateSubsetSum(item -> true);
        double weight = 0.0;
        for (int i = 1; i <= 200; ++i) {
            weight += 1000.0 / (double)i;
        }
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)weight, (double)1.0E-13);
    }

    @Test(groups={"check_cpp_files"})
    public void deserializeFromCppSketchLongsSampling() throws IOException {
        byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("varopt_sketch_long_sampling_cpp.sk"));
        VarOptItemsSketch sk = VarOptItemsSketch.heapify((MemorySegment)MemorySegment.ofArray(bytes), (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Assert.assertEquals((int)sk.getK(), (int)1024);
        Assert.assertEquals((long)sk.getN(), (long)2003L);
        Assert.assertEquals((int)sk.getNumSamples(), (int)1024);
        SampleSubsetSummary ss = sk.estimateSubsetSum(item -> true);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)332000.0, (double)1.0E-13);
        ss = sk.estimateSubsetSum(item -> item < 0L);
        Assert.assertEquals((double)ss.getEstimate(), (double)330000.0);
        ss = sk.estimateSubsetSum(item -> item >= 0L);
        Assert.assertEquals((double)ss.getEstimate(), (double)2000.0, (double)1.0E-13);
    }

    @Test(groups={"check_cpp_files"})
    public void deserializeFromCppUnionDoubleSampling() throws IOException {
        byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("varopt_union_double_sampling_cpp.sk"));
        VarOptItemsUnion u = VarOptItemsUnion.heapify((MemorySegment)MemorySegment.ofArray(bytes), (ArrayOfItemsSerDe)new ArrayOfDoublesSerDe());
        VarOptItemsSketch sk = u.getResult();
        Assert.assertTrue((sk.getK() < 128 ? 1 : 0) != 0);
        Assert.assertEquals((long)sk.getN(), (long)97L);
        SampleSubsetSummary ss = sk.estimateSubsetSum(item -> item >= 0.0);
        Assert.assertEquals((double)ss.getEstimate(), (double)96.0, (double)1.0E-13);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)1120.0, (double)1.0E-13);
    }
}

