/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnionImpl;

public abstract class ThetaUnion
extends ThetaSetOperation {
    public static ThetaUnion fastWrap(MemorySegment srcSeg) {
        return ThetaUnion.fastWrap(srcSeg, 9001L);
    }

    public static ThetaUnion fastWrap(MemorySegment srcSeg, long expectedSeed) {
        byte serVer = srcSeg.get(ValueLayout.JAVA_BYTE, 1L);
        if (serVer != 3) {
            throw new SketchesArgumentException("SerVer must be 3: " + serVer);
        }
        return ThetaUnionImpl.fastWrapInstance(srcSeg, expectedSeed);
    }

    public static ThetaUnion wrap(MemorySegment srcSeg) {
        return ThetaUnion.wrap(srcSeg, 9001L);
    }

    public static ThetaUnion wrap(MemorySegment srcSeg, long expectedSeed) {
        byte serVer = srcSeg.get(ValueLayout.JAVA_BYTE, 1L);
        if (serVer != 3) {
            throw new SketchesArgumentException("SerVer must be 3: " + serVer);
        }
        return ThetaUnionImpl.wrapInstance(srcSeg, expectedSeed);
    }

    public abstract int getCurrentBytes();

    @Override
    public Family getFamily() {
        return Family.UNION;
    }

    public abstract int getMaxUnionBytes();

    public abstract CompactThetaSketch getResult();

    public abstract CompactThetaSketch getResult(boolean var1, MemorySegment var2);

    public abstract void reset();

    public abstract byte[] toByteArray();

    public CompactThetaSketch union(ThetaSketch sketchA, ThetaSketch sketchB) {
        return this.union(sketchA, sketchB, true, null);
    }

    public abstract CompactThetaSketch union(ThetaSketch var1, ThetaSketch var2, boolean var3, MemorySegment var4);

    public abstract void union(ThetaSketch var1);

    public abstract void union(MemorySegment var1);

    public abstract void update(long var1);

    public abstract void update(double var1);

    public abstract void update(String var1);

    public abstract void update(byte[] var1);

    public abstract void update(ByteBuffer var1);

    public abstract void update(int[] var1);

    public abstract void update(char[] var1);

    public abstract void update(long[] var1);
}

