/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import jdk.incubator.foreign.ResourceScope;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class IgnoredArrayOverflowTest {
    private static final MemoryRequestServer memReqSvr = Resource.defaultMemReqSvr;
    private WritableMemory memory;
    private static final long MAX_SIZE = 1024L;

    @BeforeClass
    public void allocate() {
        ResourceScope scope = ResourceScope.newConfinedScope();
        this.memory = WritableMemory.allocateDirect((long)1024L, (long)8L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
    }

    @AfterClass
    public void close() throws Exception {
        this.memory.close();
    }

    @Test
    public void testCharArray() {
        int size = (int)(this.memory.getCapacity() / 2L);
        char[] array = new char[size];
        this.memory.getCharArray(0L, array, 0, size);
        this.memory.asBuffer().getCharArray(array, 0, size);
        this.memory.putCharArray(0L, array, 0, size);
        this.memory.asWritableBuffer().putCharArray(array, 0, size);
    }

    @Test
    public void testShortArray() {
        int size = (int)(this.memory.getCapacity() / 2L);
        short[] array = new short[size];
        this.memory.getShortArray(0L, array, 0, size);
        this.memory.asBuffer().getShortArray(array, 0, size);
        this.memory.putShortArray(0L, array, 0, size);
        this.memory.asWritableBuffer().putShortArray(array, 0, size);
    }

    @Test
    public void testIntArray() {
        int size = (int)(this.memory.getCapacity() / 4L);
        int[] array = new int[size];
        this.memory.getIntArray(0L, array, 0, size);
        this.memory.asBuffer().getIntArray(array, 0, size);
        this.memory.putIntArray(0L, array, 0, size);
        this.memory.asWritableBuffer().putIntArray(array, 0, size);
    }

    @Test
    public void testFloatArray() {
        int size = (int)(this.memory.getCapacity() / 4L);
        float[] array = new float[size];
        this.memory.getFloatArray(0L, array, 0, size);
        this.memory.asBuffer().getFloatArray(array, 0, size);
        this.memory.putFloatArray(0L, array, 0, size);
        this.memory.asWritableBuffer().putFloatArray(array, 0, size);
    }

    @Test
    public void testLongArray() {
        int size = (int)(this.memory.getCapacity() / 8L);
        long[] array = new long[size];
        this.memory.getLongArray(0L, array, 0, size);
        this.memory.asBuffer().getLongArray(array, 0, size);
        this.memory.putLongArray(0L, array, 0, size);
        this.memory.asWritableBuffer().putLongArray(array, 0, size);
    }

    @Test
    public void testDoubleArray() {
        int size = (int)(this.memory.getCapacity() / 8L);
        double[] array = new double[size];
        this.memory.getDoubleArray(0L, array, 0, size);
        this.memory.asBuffer().getDoubleArray(array, 0, size);
        this.memory.putDoubleArray(0L, array, 0, size);
        this.memory.asWritableBuffer().putDoubleArray(array, 0, size);
    }
}

