/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import jdk.incubator.foreign.MemoryAccess;
import jdk.incubator.foreign.MemorySegment;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.internal.WritableBufferImpl;

final class NativeWritableBufferImpl
extends WritableBufferImpl {
    NativeWritableBufferImpl(MemorySegment seg, int typeId, MemoryRequestServer memReqSvr) {
        super(seg, typeId, memReqSvr);
    }

    @Override
    public char getChar() {
        long pos = this.getPosition();
        this.setPosition(pos + 2L);
        return MemoryAccess.getCharAtOffset((MemorySegment)this.seg, (long)pos);
    }

    @Override
    public char getChar(long offsetBytes) {
        return MemoryAccess.getCharAtOffset((MemorySegment)this.seg, (long)offsetBytes);
    }

    @Override
    public void getCharArray(char[] dstArray, int dstOffsetChars, int lengthChars) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthChars << 1;
        MemorySegment srcSlice = this.seg.asSlice(pos, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((char[])dstArray).asSlice((long)(dstOffsetChars << 1), copyBytes);
        dstSlice.copyFrom(srcSlice);
        this.setPosition(pos + copyBytes);
    }

    @Override
    public double getDouble() {
        long pos = this.getPosition();
        this.setPosition(pos + 8L);
        return MemoryAccess.getDoubleAtOffset((MemorySegment)this.seg, (long)pos);
    }

    @Override
    public double getDouble(long offsetBytes) {
        return MemoryAccess.getDoubleAtOffset((MemorySegment)this.seg, (long)offsetBytes);
    }

    @Override
    public void getDoubleArray(double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthDoubles << 3;
        MemorySegment srcSlice = this.seg.asSlice(pos, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((double[])dstArray).asSlice((long)(dstOffsetDoubles << 3), copyBytes);
        dstSlice.copyFrom(srcSlice);
        this.setPosition(pos + copyBytes);
    }

    @Override
    public float getFloat() {
        long pos = this.getPosition();
        this.setPosition(pos + 4L);
        return MemoryAccess.getFloatAtOffset((MemorySegment)this.seg, (long)pos);
    }

    @Override
    public float getFloat(long offsetBytes) {
        return MemoryAccess.getFloatAtOffset((MemorySegment)this.seg, (long)offsetBytes);
    }

    @Override
    public void getFloatArray(float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthFloats << 2;
        MemorySegment srcSlice = this.seg.asSlice(pos, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((float[])dstArray).asSlice((long)(dstOffsetFloats << 2), copyBytes);
        dstSlice.copyFrom(srcSlice);
        this.setPosition(pos + copyBytes);
    }

    @Override
    public int getInt() {
        long pos = this.getPosition();
        this.setPosition(pos + 4L);
        return MemoryAccess.getIntAtOffset((MemorySegment)this.seg, (long)pos);
    }

    @Override
    public int getInt(long offsetBytes) {
        return MemoryAccess.getIntAtOffset((MemorySegment)this.seg, (long)offsetBytes);
    }

    @Override
    public void getIntArray(int[] dstArray, int dstOffsetInts, int lengthInts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthInts << 2;
        MemorySegment srcSlice = this.seg.asSlice(pos, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((int[])dstArray).asSlice((long)(dstOffsetInts << 2), copyBytes);
        dstSlice.copyFrom(srcSlice);
        this.setPosition(pos + copyBytes);
    }

    @Override
    public long getLong() {
        long pos = this.getPosition();
        this.setPosition(pos + 8L);
        return MemoryAccess.getLongAtOffset((MemorySegment)this.seg, (long)pos);
    }

    @Override
    public long getLong(long offsetBytes) {
        return MemoryAccess.getLongAtOffset((MemorySegment)this.seg, (long)offsetBytes);
    }

    @Override
    public void getLongArray(long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthLongs << 3;
        MemorySegment srcSlice = this.seg.asSlice(pos, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((long[])dstArray).asSlice((long)(dstOffsetLongs << 3), copyBytes);
        dstSlice.copyFrom(srcSlice);
        this.setPosition(pos + copyBytes);
    }

    @Override
    public short getShort() {
        long pos = this.getPosition();
        this.setPosition(pos + 2L);
        return MemoryAccess.getShortAtOffset((MemorySegment)this.seg, (long)pos);
    }

    @Override
    public short getShort(long offsetBytes) {
        return MemoryAccess.getShortAtOffset((MemorySegment)this.seg, (long)offsetBytes);
    }

    @Override
    public void getShortArray(short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthShorts << 1;
        MemorySegment srcSlice = this.seg.asSlice(pos, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((short[])dstArray).asSlice((long)(dstOffsetShorts << 1), copyBytes);
        dstSlice.copyFrom(srcSlice);
        this.setPosition(pos + copyBytes);
    }

    @Override
    public void putChar(char value) {
        long pos = this.getPosition();
        this.setPosition(pos + 2L);
        MemoryAccess.setCharAtOffset((MemorySegment)this.seg, (long)pos, (char)value);
    }

    @Override
    public void putChar(long offsetBytes, char value) {
        MemoryAccess.setCharAtOffset((MemorySegment)this.seg, (long)offsetBytes, (char)value);
    }

    @Override
    public void putCharArray(char[] srcArray, int srcOffsetChars, int lengthChars) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthChars << 1;
        MemorySegment srcSlice = MemorySegment.ofArray((char[])srcArray).asSlice((long)(srcOffsetChars << 1), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(pos, copyBytes);
        dstSlice.copyFrom(srcSlice);
        this.setPosition(pos + copyBytes);
    }

    @Override
    public void putDouble(double value) {
        long pos = this.getPosition();
        this.setPosition(pos + 8L);
        MemoryAccess.setDoubleAtOffset((MemorySegment)this.seg, (long)pos, (double)value);
    }

    @Override
    public void putDouble(long offsetBytes, double value) {
        MemoryAccess.setDoubleAtOffset((MemorySegment)this.seg, (long)offsetBytes, (double)value);
    }

    @Override
    public void putDoubleArray(double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthDoubles << 3;
        MemorySegment srcSlice = MemorySegment.ofArray((double[])srcArray).asSlice((long)(srcOffsetDoubles << 3), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(pos, copyBytes);
        dstSlice.copyFrom(srcSlice);
        this.setPosition(pos + copyBytes);
    }

    @Override
    public void putFloat(float value) {
        long pos = this.getPosition();
        this.setPosition(pos + 4L);
        MemoryAccess.setFloatAtOffset((MemorySegment)this.seg, (long)pos, (float)value);
    }

    @Override
    public void putFloat(long offsetBytes, float value) {
        MemoryAccess.setFloatAtOffset((MemorySegment)this.seg, (long)offsetBytes, (float)value);
    }

    @Override
    public void putFloatArray(float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthFloats << 2;
        MemorySegment srcSlice = MemorySegment.ofArray((float[])srcArray).asSlice((long)(srcOffsetFloats << 2), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(pos, copyBytes);
        dstSlice.copyFrom(srcSlice);
        this.setPosition(pos + copyBytes);
    }

    @Override
    public void putInt(int value) {
        long pos = this.getPosition();
        this.setPosition(pos + 4L);
        MemoryAccess.setIntAtOffset((MemorySegment)this.seg, (long)pos, (int)value);
    }

    @Override
    public void putInt(long offsetBytes, int value) {
        MemoryAccess.setIntAtOffset((MemorySegment)this.seg, (long)offsetBytes, (int)value);
    }

    @Override
    public void putIntArray(int[] srcArray, int srcOffsetInts, int lengthInts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthInts << 2;
        MemorySegment srcSlice = MemorySegment.ofArray((int[])srcArray).asSlice((long)(srcOffsetInts << 2), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(pos, copyBytes);
        dstSlice.copyFrom(srcSlice);
        this.setPosition(pos + copyBytes);
    }

    @Override
    public void putLong(long value) {
        long pos = this.getPosition();
        this.setPosition(pos + 8L);
        MemoryAccess.setLongAtOffset((MemorySegment)this.seg, (long)pos, (long)value);
    }

    @Override
    public void putLong(long offsetBytes, long value) {
        MemoryAccess.setLongAtOffset((MemorySegment)this.seg, (long)offsetBytes, (long)value);
    }

    @Override
    public void putLongArray(long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthLongs << 3;
        MemorySegment srcSlice = MemorySegment.ofArray((long[])srcArray).asSlice((long)(srcOffsetLongs << 3), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(pos, copyBytes);
        dstSlice.copyFrom(srcSlice);
        this.setPosition(pos + copyBytes);
    }

    @Override
    public void putShort(short value) {
        long pos = this.getPosition();
        this.setPosition(pos + 2L);
        MemoryAccess.setShortAtOffset((MemorySegment)this.seg, (long)pos, (short)value);
    }

    @Override
    public void putShort(long offsetBytes, short value) {
        MemoryAccess.setShortAtOffset((MemorySegment)this.seg, (long)offsetBytes, (short)value);
    }

    @Override
    public void putShortArray(short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthShorts << 1;
        MemorySegment srcSlice = MemorySegment.ofArray((short[])srcArray).asSlice((long)(srcOffsetShorts << 1), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(pos, copyBytes);
        dstSlice.copyFrom(srcSlice);
        this.setPosition(pos + copyBytes);
    }
}

