/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.MemoryRequestServer;

public interface Resource {
    public static final MemoryRequestServer defaultMemReqSvr = new DefaultMemoryRequestServer(8L, ByteOrder.nativeOrder(), false, false);

    public MemoryRequestServer getMemoryRequestServer();

    public boolean hasMemoryRequestServer();

    public void setMemoryRequestServer(MemoryRequestServer var1);

    public ByteBuffer asByteBufferView(ByteOrder var1);

    public int compareTo(long var1, long var3, Resource var5, long var6, long var8);

    default public boolean equalTo(Resource that) {
        if (that == null || this.getCapacity() != that.getCapacity()) {
            return false;
        }
        return this.equalTo(0L, that, 0L, that.getCapacity());
    }

    public boolean equalTo(long var1, Resource var3, long var4, long var6);

    public void force();

    public Arena getArena();

    public long getCapacity();

    public MemorySegment getMemorySegment();

    public long getRelativeOffset(Resource var1);

    public ByteOrder getTypeByteOrder();

    public boolean hasByteBuffer();

    public boolean isAlive();

    public boolean isBuffer();

    public boolean isByteOrderCompatible(ByteOrder var1);

    public boolean isDirect();

    public boolean isDuplicate();

    public boolean isHeap();

    public boolean isLoaded();

    public boolean isMapped();

    public boolean isMemory();

    public boolean isReadOnly();

    public boolean isRegion();

    public boolean isSameResource(Resource var1);

    public void load();

    public long mismatch(Resource var1);

    public long mismatch(Resource var1, long var2, long var4, Resource var6, long var7, long var9);

    public long nativeOverlap(Resource var1);

    public MemorySegment.Scope scope();

    public ByteBuffer toByteBuffer(ByteOrder var1);

    public MemorySegment toMemorySegment(Arena var1, long var2);

    public String toString();

    public String toString(String var1, long var2, int var4, boolean var5);

    public void unload();

    public long xxHash64(long var1, long var3);

    public long xxHash64(long var1, long var3, long var5);
}

