/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.hll;

import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.pig.hll.SketchToEstimateAndErrorBounds;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SketchToEstimateAndErrorBoundsTest {
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();

    @Test
    public void nullInputTuple() throws Exception {
        SketchToEstimateAndErrorBounds func = new SketchToEstimateAndErrorBounds();
        Tuple result = (Tuple)func.exec(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptyInputTuple() throws Exception {
        SketchToEstimateAndErrorBounds func = new SketchToEstimateAndErrorBounds();
        Tuple result = (Tuple)func.exec(tupleFactory.newTuple());
        Assert.assertNull((Object)result);
    }

    @Test
    public void normalCase() throws Exception {
        SketchToEstimateAndErrorBounds func = new SketchToEstimateAndErrorBounds();
        HllSketch sketch = new HllSketch(12);
        sketch.update(1L);
        sketch.update(2L);
        Tuple result = (Tuple)func.exec(tupleFactory.newTuple((Object)new DataByteArray(sketch.toCompactByteArray())));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)((Double)result.get(0)), (double)2.0, (double)0.01);
        Assert.assertTrue(((Double)result.get(1) <= 2.0 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)result.get(2) >= 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void schema() throws Exception {
        SketchToEstimateAndErrorBounds func = new SketchToEstimateAndErrorBounds();
        Schema inputSchema = new Schema(new Schema.FieldSchema("Sketch", 50));
        Schema outputSchema = func.outputSchema(inputSchema);
        Assert.assertNotNull((Object)outputSchema);
        Assert.assertEquals((int)outputSchema.size(), (int)1);
        Assert.assertEquals((String)DataType.findTypeName((byte)outputSchema.getField((int)0).type), (String)"tuple");
        Schema innerSchema = outputSchema.getField((int)0).schema;
        Assert.assertEquals((int)innerSchema.size(), (int)3);
        Assert.assertEquals((String)DataType.findTypeName((byte)innerSchema.getField((int)0).type), (String)"double");
        Assert.assertEquals((String)DataType.findTypeName((byte)innerSchema.getField((int)1).type), (String)"double");
        Assert.assertEquals((String)DataType.findTypeName((byte)innerSchema.getField((int)2).type), (String)"double");
    }
}

