/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DynamicLikeOptimizationTest
extends BaseJDBCTestCase {
    private static final Object[][] CEI_ROWS = new Object[][]{{0, "Alarms", "AlarmDisk999"}, {1, "Alarms", "AlarmFS-usr"}, {2, "Alarms", "AlarmPower"}, {3, "Alert", "AlertBattery"}, {4, "Alert", "AlertUPS"}, {5, "Warning", "WarnIntrusion"}, {6, "Warning", "WarnUnlockDoor"}, {7, "Warning", "Warn%Unlock%Door"}, {8, "Warning", "W_Unlock_Door"}};

    public DynamicLikeOptimizationTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite tests = new BaseTestSuite("DynamicLikeOptimizationTest");
        tests.addTestSuite(DynamicLikeOptimizationTest.class);
        tests.addTest(TestConfiguration.clientServerDecorator((Test)new BaseTestSuite(DynamicLikeOptimizationTest.class)));
        return new CleanDatabaseTestSetup((Test)tests){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.executeUpdate("create table t1(c11 int)");
                stmt.executeUpdate("insert into t1 values 1");
                stmt.executeUpdate("create table test(id char(10), c10 char(10), vc10 varchar(10))");
                PreparedStatement insert = this.getConnection().prepareStatement("insert into test values (?,?,?)");
                String[] values = new String[]{"asdf", "asdg", "aasdf", "%foobar", "foo%bar", "foo_bar"};
                for (int i = 0; i < values.length; ++i) {
                    for (int j = 1; j <= 3; ++j) {
                        insert.setString(j, values[i]);
                    }
                    insert.executeUpdate();
                }
                insert.setString(1, "V-NULL");
                insert.setString(2, null);
                insert.setString(3, null);
                insert.executeUpdate();
                insert.setString(1, "MAX_CHAR");
                insert.setString(2, "\ufa2d");
                insert.setString(3, "\ufa2d");
                insert.executeUpdate();
                insert.close();
                stmt.executeUpdate("create table likeable(match_me varchar(10), pattern varchar(10), esc varchar(1))");
                stmt.executeUpdate("insert into likeable values ('foo%bar', 'fooZ%bar', 'Z'), ('foo%bar', '%Z%ba_', 'Z'),('foo%bar', 'fooZ%baZ', 'Z')");
                stmt.executeUpdate("create table cei(id int, name varchar(192) not null, source varchar(252) not null)");
                PreparedStatement cei = this.getConnection().prepareStatement("insert into cei values (?,?,?)");
                for (int i = 0; i < CEI_ROWS.length; ++i) {
                    for (int j = 0; j < CEI_ROWS[i].length; ++j) {
                        cei.setObject(j + 1, CEI_ROWS[i][j]);
                    }
                    cei.executeUpdate();
                }
                cei.close();
            }
        };
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    public void testSimpleLikePredicates() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select 1 from t1 where 'asdf' like ?");
        String[] one = new String[]{"%", "%f", "asd%", "_%", "%_", "%asdf"};
        for (int i = 0; i < one.length; ++i) {
            ps.setString(1, one[i]);
            JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
        }
        String[] empty = new String[]{"", "%g", "_asdf", null};
        for (int i = 0; i < empty.length; ++i) {
            ps.setObject(1, (Object)empty[i], 12);
            JDBC.assertEmpty(ps.executeQuery());
        }
        ps.close();
    }

    public void testEscapeSyntax() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select 1 from t1 where '%foobar' like 'Z%foobar' escape ?");
        ps.setString(1, "Z");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
        String[][] invalid = new String[][]{{"raZ", "22019"}, {"", "22019"}, {null, "22501"}};
        for (int i = 0; i < invalid.length; ++i) {
            ps.setObject(1, (Object)invalid[i][0], 12);
            try {
                ps.executeQuery();
                DynamicLikeOptimizationTest.fail();
                continue;
            }
            catch (SQLException e) {
                DynamicLikeOptimizationTest.assertSQLState(invalid[i][1], e);
            }
        }
        ps.setString(1, "%");
        JDBC.assertEmpty(ps.executeQuery());
        ps.close();
    }

    public void testWildcardAsEscape() throws SQLException {
        Statement s = this.createStatement();
        JDBC.assertSingleValueResultSet(s.executeQuery("select 1 from t1 where '%foobar' like '%%foobar' escape '%'"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select 1 from t1 where '_foobar' like '__foobar' escape '_'"), "1");
        s.close();
    }

    public void testEscapeSyntax2() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select 1 from t1 where '%foobar' like ? escape ?");
        ps.setString(1, "Z%foobar");
        ps.setString(2, "Z");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
        ps.setString(2, "");
        try {
            ps.executeQuery();
            DynamicLikeOptimizationTest.fail();
        }
        catch (SQLException e) {
            DynamicLikeOptimizationTest.assertSQLState("22019", e);
        }
        ps.close();
    }

    public void testEscapeSyntax3() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select 1 from t1 where '%foobar' like ? escape 'Z'");
        ps.setString(1, "x%foobar");
        JDBC.assertEmpty(ps.executeQuery());
        ps.setString(1, "Z%foobar");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
        ps.close();
    }

    public void testEscapeSyntax4() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select 1 from t1 where '%foobar' like ? escape '$'");
        ps.setString(1, "$%f%bar");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
        ps.close();
    }

    public void testEscapeSyntax5() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select 1 from t1 where 'Z%foobar' like ? escape 'Z'");
        ps.setString(1, "ZZZ%foo%a_");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
        ps.close();
    }

    public void testLikeWithHighestValidCharacter() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select 1 from t1 where '\ufa2d' like ?");
        String[] match = new String[]{"%", "_", "\ufa2d"};
        for (int i = 0; i < match.length; ++i) {
            ps.setString(1, match[i]);
            JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
        }
        ps.setString(1, "");
        JDBC.assertEmpty(ps.executeQuery());
        ps.close();
    }

    public void testGeneratedPredicatesCHAR() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select id from test where c10 like ?");
        String[][][] expected = new String[][][]{new String[0][], new String[0][], new String[0][], {{"MAX_CHAR"}, {"asdf"}, {"asdg"}, {"aasdf"}, {"%foobar"}, {"foo%bar"}, {"foo_bar"}}, new String[0][], new String[0][], {{"asdf"}, {"asdg"}}, {{"MAX_CHAR"}, {"asdf"}, {"asdg"}, {"aasdf"}, {"%foobar"}, {"foo%bar"}, {"foo_bar"}}, {{"MAX_CHAR"}, {"asdf"}, {"asdg"}, {"aasdf"}, {"%foobar"}, {"foo%bar"}, {"foo_bar"}}, new String[0][], {{"aasdf"}}, new String[0][]};
        this.testGeneratedPredicates(ps, expected);
    }

    public void testGeneratedPredicatesVARCHAR() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select id from test where vc10 like ?");
        String[][][] expected = new String[][][]{new String[0][], new String[0][], new String[0][], {{"MAX_CHAR"}, {"asdf"}, {"asdg"}, {"aasdf"}, {"%foobar"}, {"foo%bar"}, {"foo_bar"}}, {{"asdf"}, {"aasdf"}}, {{"asdg"}}, {{"asdf"}, {"asdg"}}, {{"MAX_CHAR"}, {"asdf"}, {"asdg"}, {"aasdf"}, {"%foobar"}, {"foo%bar"}, {"foo_bar"}}, {{"MAX_CHAR"}, {"asdf"}, {"asdg"}, {"aasdf"}, {"%foobar"}, {"foo%bar"}, {"foo_bar"}}, {{"aasdf"}}, new String[0][], {{"asdf"}, {"aasdf"}}};
        this.testGeneratedPredicates(ps, expected);
    }

    private void testGeneratedPredicates(PreparedStatement ps, String[][][] rows) throws SQLException {
        Object[] args = new Object[]{null, 1, "", "%", "%f", "%g", "asd%", "_%", "%_", "_asdf", "_asdf %", "%asdf"};
        DynamicLikeOptimizationTest.assertEquals((int)args.length, (int)rows.length);
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                ps.setString(1, null);
            } else {
                ps.setObject(1, args[i]);
            }
            JDBC.assertUnorderedResultSet(ps.executeQuery(), rows[i]);
        }
        ps.close();
    }

    public void testStringAndPatternAndEscapeFromTable() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select match_me from likeable where match_me like pattern escape esc");
        ResultSet rs = null;
        boolean twoSuccessful = false;
        try {
            rs = ps.executeQuery();
            DynamicLikeOptimizationTest.assertTrue((boolean)rs.next());
            DynamicLikeOptimizationTest.assertTrue((boolean)rs.next());
            twoSuccessful = true;
            rs.next();
            DynamicLikeOptimizationTest.fail();
        }
        catch (SQLException e) {
            DynamicLikeOptimizationTest.assertSQLState("22025", e);
            DynamicLikeOptimizationTest.assertTrue((DynamicLikeOptimizationTest.usingEmbedded() && twoSuccessful || DynamicLikeOptimizationTest.usingDerbyNetClient() && rs == null ? 1 : 0) != 0);
        }
        if (rs != null) {
            rs.close();
        }
        PreparedStatement del = this.prepareStatement("delete from likeable");
        DynamicLikeOptimizationTest.assertEquals((int)3, (int)del.executeUpdate());
        PreparedStatement ins = this.prepareStatement("insert into likeable values (?, ?, ?)");
        ins.setString(1, "foo%bar");
        ins.setString(2, "foo%bar");
        ins.setString(3, null);
        ins.executeUpdate();
        try {
            JDBC.assertDrainResults(ps.executeQuery());
            DynamicLikeOptimizationTest.fail();
        }
        catch (SQLException e) {
            DynamicLikeOptimizationTest.assertSQLState("22501", e);
        }
        DynamicLikeOptimizationTest.assertEquals((int)1, (int)del.executeUpdate());
        ins.setString(3, "");
        ins.executeUpdate();
        try {
            JDBC.assertDrainResults(ps.executeQuery());
            DynamicLikeOptimizationTest.fail();
        }
        catch (SQLException e) {
            DynamicLikeOptimizationTest.assertSQLState("22019", e);
        }
        ps.close();
        del.close();
        ins.close();
    }

    public void testEscapeWithBackslash() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select id, name, source from cei where (name LIKE ? escape '\\') and (source like ? escape '\\') order by source asc, name asc");
        HashMap<String[], Object[][]> inputOutput = new HashMap<String[], Object[][]>();
        inputOutput.put(new String[]{"%", "%"}, new Object[][]{CEI_ROWS[0], CEI_ROWS[1], CEI_ROWS[2], CEI_ROWS[3], CEI_ROWS[4], CEI_ROWS[8], CEI_ROWS[7], CEI_ROWS[5], CEI_ROWS[6]});
        inputOutput.put(new String[]{"Alarms", "AlarmDisk%"}, new Object[][]{CEI_ROWS[0]});
        inputOutput.put(new String[]{"A%", "%"}, new Object[][]{CEI_ROWS[0], CEI_ROWS[1], CEI_ROWS[2], CEI_ROWS[3], CEI_ROWS[4]});
        inputOutput.put(new String[]{"%", "___rm%"}, new Object[][]{CEI_ROWS[0], CEI_ROWS[1], CEI_ROWS[2]});
        inputOutput.put(new String[]{"Warning", "%oor"}, new Object[][]{CEI_ROWS[8], CEI_ROWS[7], CEI_ROWS[6]});
        inputOutput.put(new String[]{"Warning", "Warn\\%Unlock\\%Door"}, new Object[][]{CEI_ROWS[7]});
        inputOutput.put(new String[]{"Warning", "%\\%Unlo%"}, new Object[][]{CEI_ROWS[7]});
        inputOutput.put(new String[]{"Warning", "W\\_Unloc%"}, new Object[][]{CEI_ROWS[8]});
        inputOutput.put(new String[]{"Warning", "_\\_Unlock\\_Door"}, new Object[][]{CEI_ROWS[8]});
        inputOutput.put(new String[]{"W%", "Warn\\%Unlock\\%Door"}, new Object[][]{CEI_ROWS[7]});
        inputOutput.put(new String[]{"%ing", "W\\_Unlock\\_%Door"}, new Object[][]{CEI_ROWS[8]});
        inputOutput.put(new String[]{"Bogus", "Name"}, new Object[0][]);
        for (Map.Entry entry : inputOutput.entrySet()) {
            String[] args = (String[])entry.getKey();
            Object[][] rows = (Object[][])entry.getValue();
            ps.setObject(1, args[0]);
            ps.setObject(2, args[1]);
            JDBC.assertFullResultSet(ps.executeQuery(), rows, false);
        }
        ps.close();
    }

    public void testTabs() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("insert into test values ('asd\tp', 'asd\tp', 'asd\tp'), ('ase\tp', 'ase\tg', 'ase\tg')");
        String[][] expected = new String[][]{{"asdf"}, {"asdg"}, {"asd\tp"}};
        JDBC.assertUnorderedResultSet(s.executeQuery("select c10 from test where c10 like 'asd%'"), expected);
        PreparedStatement ps = this.prepareStatement("select c10 from test where c10 like ?");
        ps.setString(1, "asd%");
        JDBC.assertUnorderedResultSet(ps.executeQuery(), expected);
        s.close();
        ps.close();
    }

    public void testEscapedEscapeCharacterPrecedingFirstWildcard() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("insert into test values ('abc#def', 'abc#def', 'abc#def'), ('abc\\def', 'abc\\def', 'abc\\def')");
        PreparedStatement[] ps = new PreparedStatement[]{this.prepareStatement("select id from test where c10 like ? escape ?"), this.prepareStatement("select id from test where vc10 like ? escape ?")};
        String[][] inputOutput = new String[][]{{"abc##%", "#", "abc#def", "abc#def"}, {"abc\\\\%", "\\", "abc\\def", "abc\\def"}, {"abc##_ef", "#", null, "abc#def"}, {"abc\\\\_ef", "\\", null, "abc\\def"}};
        for (int i = 0; i < inputOutput.length; ++i) {
            for (int j = 0; j < ps.length; ++j) {
                ps[j].setString(1, inputOutput[i][0]);
                ps[j].setString(2, inputOutput[i][1]);
                ResultSet rs = ps[j].executeQuery();
                String expected = inputOutput[i][2 + j];
                if (expected == null) {
                    JDBC.assertEmpty(rs);
                    continue;
                }
                JDBC.assertSingleValueResultSet(rs, expected);
            }
        }
        s.close();
        ps[0].close();
        ps[1].close();
    }

    public void testDynamicLikeOptimization() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')");
        if (rs.next() && rs.getString(1).equals("TERRITORY_BASED")) {
            rs.close();
            s.close();
            return;
        }
        s.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        PreparedStatement ps = this.prepareStatement("select id from test where vc10 like ?");
        ps.setString(1, "%");
        JDBC.assertDrainResults(ps.executeQuery());
        RuntimeStatisticsParser p = SQLUtilities.getRuntimeStatisticsParser(s);
        DynamicLikeOptimizationTest.assertTrue((boolean)p.hasGreaterThanOrEqualQualifier());
        DynamicLikeOptimizationTest.assertTrue((boolean)p.hasLessThanQualifier());
        s.close();
        ps.close();
    }

    public void testCast() throws SQLException {
        Statement s = this.createStatement();
        JDBC.assertSingleValueResultSet(s.executeQuery("select 1 from t1 where 'asdf' like cast('%f' as varchar(2))"), "1");
        JDBC.assertEmpty(s.executeQuery("select 1 from t1 where 'asdf' like cast(null as char)"));
        JDBC.assertSingleValueResultSet(s.executeQuery("select 1 from t1 where '%foobar' like 'Z%foobar' escape cast('Z' as varchar(1))"), "1");
        JDBC.assertEmpty(s.executeQuery("select vc10 from test where vc10 like 'values cast(null as varchar(1))'"));
        JDBC.assertEmpty(s.executeQuery("select id from test where c10 like cast ('%f' as varchar(2))"));
        JDBC.assertUnorderedResultSet(s.executeQuery("select id from test where vc10 like cast ('%f' as varchar(2))"), new String[][]{{"asdf"}, {"aasdf"}});
        s.close();
    }
}

