/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.security.Securable;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ExportAbstract;
import org.apache.derby.impl.load.ExportWriteData;
import org.apache.derby.impl.load.ExportWriteDataAbstract;
import org.apache.derby.impl.load.LoadError;

public class Export
extends ExportAbstract {
    private String outputFileName;
    private String lobsFileName;

    private void doExport() throws SQLException {
        try {
            if (this.entityName == null && this.selectStatement == null) {
                throw LoadError.entityNameMissing();
            }
            if (this.outputFileName == null) {
                throw LoadError.dataFileNull();
            }
            if (this.dataFileExists(this.outputFileName)) {
                throw LoadError.dataFileExists(this.outputFileName);
            }
            if (this.lobsFileName != null && this.lobsFileExists(this.lobsFileName)) {
                throw LoadError.lobsFileExists(this.lobsFileName);
            }
            try {
                this.doAllTheWork();
            }
            catch (IOException iex) {
                throw LoadError.errorWritingData(iex);
            }
        }
        catch (Exception ex) {
            throw LoadError.unexpectedError(ex);
        }
    }

    private Export(Connection con, String schemaName, String tableName, String selectStatement, String outputFileName, String characterDelimeter, String columnDelimeter, String codeset) throws SQLException {
        this.con = con;
        this.schemaName = schemaName;
        this.entityName = tableName;
        this.selectStatement = selectStatement;
        this.outputFileName = outputFileName;
        try {
            this.controlFileReader = new ControlInfo();
            this.controlFileReader.setControlProperties(characterDelimeter, columnDelimeter, codeset);
        }
        catch (Exception ex) {
            throw LoadError.unexpectedError(ex);
        }
    }

    private void setLobsExtFileName(String lobsFileName) throws SQLException {
        if (lobsFileName == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE0Q.S", new Object[0]));
        }
        this.lobsFileName = lobsFileName;
        this.lobsInExtFile = true;
    }

    private boolean lobsFileExists(String fileName) throws SQLException {
        if (fileName == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE0Q.S", new Object[0]));
        }
        fileName = FileUtil.stripProtocolFromFileName(fileName);
        File file = new File(fileName);
        return this.fileExists(file);
    }

    private boolean dataFileExists(String fileName) throws SQLException {
        if (fileName == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE05.S", new Object[0]));
        }
        fileName = FileUtil.stripProtocolFromFileName(fileName);
        File file = new File(fileName);
        return this.fileExists(file);
    }

    private final boolean fileExists(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
    }

    public static void exportTable(Connection con, String schemaName, String tableName, String outputFileName, String columnDelimeter, String characterDelimeter, String codeset) throws SQLException {
        try {
            SecurityUtil.authorize(Securable.EXPORT_TABLE);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        Export fex = new Export(con, schemaName, tableName, null, outputFileName, characterDelimeter, columnDelimeter, codeset);
        fex.doExport();
    }

    public static void exportTable(Connection con, String schemaName, String tableName, String outputFileName, String columnDelimeter, String characterDelimeter, String codeset, String lobsFileName) throws SQLException {
        Export fex = new Export(con, schemaName, tableName, null, outputFileName, characterDelimeter, columnDelimeter, codeset);
        fex.setLobsExtFileName(lobsFileName);
        fex.doExport();
    }

    public static void exportQuery(Connection con, String selectStatement, String outputFileName, String columnDelimeter, String characterDelimeter, String codeset) throws SQLException {
        Export fex = new Export(con, null, null, selectStatement, outputFileName, characterDelimeter, columnDelimeter, codeset);
        fex.doExport();
    }

    public static void exportQuery(Connection con, String selectStatement, String outputFileName, String columnDelimeter, String characterDelimeter, String codeset, String lobsFileName) throws SQLException {
        Export fex = new Export(con, null, null, selectStatement, outputFileName, characterDelimeter, columnDelimeter, codeset);
        fex.setLobsExtFileName(lobsFileName);
        fex.doExport();
    }

    @Override
    protected ExportWriteDataAbstract getExportWriteData() throws Exception {
        if (this.lobsInExtFile) {
            return new ExportWriteData(this.outputFileName, this.lobsFileName, this.controlFileReader);
        }
        return new ExportWriteData(this.outputFileName, this.controlFileReader);
    }
}

