/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.ConglomerateFactory;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.index.B2I;
import org.apache.derby.impl.store.access.btree.index.B2I_10_3;
import org.apache.derby.impl.store.access.btree.index.B2I_v10_2;
import org.apache.derby.shared.common.sanity.SanityManager;

public class B2IFactory
implements ConglomerateFactory,
ModuleControl {
    private static final String IMPLEMENTATIONID = "BTREE";
    private static final String FORMATUUIDSTRING = "C6CEEEF0-DAD3-11d0-BB01-0060973F0942";
    private UUID formatUUID;

    @Override
    public Properties defaultProperties() {
        return new Properties();
    }

    @Override
    public boolean supportsImplementation(String implementationId) {
        return implementationId.equals(IMPLEMENTATIONID);
    }

    @Override
    public String primaryImplementationType() {
        return IMPLEMENTATIONID;
    }

    @Override
    public boolean supportsFormat(UUID formatid) {
        return formatid.equals(this.formatUUID);
    }

    @Override
    public UUID primaryFormat() {
        return this.formatUUID;
    }

    @Override
    public int getConglomerateFactoryId() {
        return 1;
    }

    @Override
    public Conglomerate createConglomerate(TransactionManager xact_mgr, int segment, long input_containerid, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int temporaryFlag) throws StandardException {
        B2I btree = null;
        btree = (temporaryFlag & 1) != 0 && xact_mgr.getAccessManager().isReadOnly() ? new B2I() : (xact_mgr.checkVersion(10, 4, null) ? new B2I() : (xact_mgr.checkVersion(10, 3, null) ? new B2I_10_3() : new B2I_v10_2()));
        btree.create(xact_mgr, segment, input_containerid, template, columnOrder, collationIds, properties, temporaryFlag);
        return btree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Conglomerate readConglomerate(TransactionManager xact_manager, ContainerKey container_key) throws StandardException {
        BTree btree = null;
        ContainerHandle container = null;
        ControlRow root = null;
        try {
            container = xact_manager.getRawStoreXact().openContainer(container_key, null, 8);
            if (container == null) {
                throw StandardException.newException("XSAI2.S", container_key.getContainerId());
            }
            root = ControlRow.get(container, 1L);
            SanityManager.ASSERT(root.getPage().isLatched());
            btree = root.getConglom(470);
            SanityManager.ASSERT(btree instanceof B2I);
        }
        finally {
            if (root != null) {
                root.release();
            }
            if (container != null) {
                container.close();
            }
        }
        return btree;
    }

    @Override
    public void insertUndoNotify(AccessFactory access_factory, Transaction xact, PageKey page_key) throws StandardException {
    }

    @Override
    public boolean canSupport(Properties startParams) {
        String impl = startParams.getProperty("derby.access.Conglomerate.type");
        if (impl == null) {
            return false;
        }
        return this.supportsImplementation(impl);
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        UUIDFactory uuidFactory = B2IFactory.getMonitor().getUUIDFactory();
        this.formatUUID = uuidFactory.recreateUUID(FORMATUUIDSTRING);
    }

    @Override
    public void stop() {
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

