/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.impl.store.raw.xact.GlobalXactId;
import org.apache.derby.impl.store.raw.xact.TransactionTableEntry;
import org.apache.derby.impl.store.raw.xact.Xact;
import org.apache.derby.impl.store.raw.xact.XactId;
import org.apache.derby.shared.common.sanity.SanityManager;

public class TransactionTable
implements Formatable {
    private final ConcurrentHashMap<TransactionId, TransactionTableEntry> trans = new ConcurrentHashMap();
    private TransactionId largestUpdateXactId;

    private TransactionTableEntry findTransactionEntry(TransactionId id) {
        SanityManager.ASSERT(id != null, "findTransacionEntry with null id");
        return this.trans.get(id);
    }

    void visitEntries(EntryVisitor visitor) {
        for (TransactionTableEntry entry : this.trans.values()) {
            if (!visitor.visit(entry)) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Xact xact, boolean exclude) {
        TransactionId id = xact.getId();
        TransactionTableEntry newEntry = new TransactionTableEntry(xact, id, 0, exclude ? 4 : 0);
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry oldEntry = this.trans.put(id, newEntry);
            SanityManager.ASSERT(oldEntry == null, "Trying to add a transaction that's already in the transaction table");
            if (SanityManager.DEBUG_ON("TranTrace")) {
                SanityManager.DEBUG("TranTrace", "adding transaction " + id);
                SanityManager.showTrace(new Throwable("TranTrace"));
            }
        }
        if (SanityManager.DEBUG_ON("memoryLeakTrace") && this.trans.size() > 50) {
            System.out.println("memoryLeakTrace:TransactionTable " + this.trans.size());
        }
    }

    boolean remove(TransactionId id) {
        TransactionTableEntry ent;
        SanityManager.ASSERT(id != null, "cannot remove transaction from table with null id");
        if (SanityManager.DEBUG_ON("TranTrace")) {
            SanityManager.DEBUG("TranTrace", "removing transaction " + id);
            SanityManager.showTrace(new Throwable("TranTrace"));
        }
        return (ent = this.trans.remove(id)) == null || ent.needExclusion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateTransaction(TransactionId tid, RawTransaction tran, int transactionStatus) {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry ent = this.findTransactionEntry(tid);
            if (ent != null) {
                ent.updateTransactionStatus((Xact)tran, transactionStatus, 1);
            } else {
                ent = new TransactionTableEntry((Xact)tran, tid, transactionStatus, 7);
                this.trans.put(tid, ent);
            }
            if (XactId.compare(ent.getXid(), this.largestUpdateXactId) > 0L) {
                this.largestUpdateXactId = ent.getXid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUpdateTransaction(TransactionId id) {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry ent = this.findTransactionEntry(id);
            SanityManager.ASSERT(ent != null, "removing update transaction that is not there");
            ent.removeUpdateTransaction();
            if (ent.isRecovery()) {
                this.remove(id);
            }
        }
    }

    void prepareTransaction(TransactionId id) {
        TransactionTableEntry ent = this.findTransactionEntry(id);
        SanityManager.ASSERT(ent != null, "preparing transaction that is not there");
        ent.prepareTransaction();
    }

    public ContextManager findTransactionContextByGlobalId(GlobalXactId global_id) {
        for (TransactionTableEntry entry : this.trans.values()) {
            GlobalTransactionId entry_gid = entry.getGid();
            if (entry_gid == null || !entry_gid.equals(global_id)) continue;
            return entry.getXact().getContextManager();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasActiveUpdateTransaction() {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            for (TransactionTableEntry entry : this.trans.values()) {
                if (!entry.isUpdate()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getTypeFormatId() {
        return 262;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            int count = 0;
            for (TransactionTableEntry entry : this.trans.values()) {
                if (!entry.isUpdate()) continue;
                ++count;
            }
            CompressedNumber.writeInt(out, count);
            if (count > 0) {
                int writeCount = 0;
                for (TransactionTableEntry entry : this.trans.values()) {
                    if (!entry.isUpdate()) continue;
                    out.writeObject(entry);
                    ++writeCount;
                }
                SanityManager.ASSERT(count == writeCount);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int count = CompressedNumber.readInt(in);
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            TransactionTableEntry ent = (TransactionTableEntry)in.readObject();
            SanityManager.ASSERT(ent.getXid() != null, "read in transaction table entry with null id");
            this.trans.put(ent.getXid(), ent);
            if (!ent.isUpdate() || XactId.compare(ent.getXid(), this.largestUpdateXactId) <= 0L) continue;
            this.largestUpdateXactId = ent.getXid();
        }
    }

    public TransactionId largestUpdateXactId() {
        return this.largestUpdateXactId;
    }

    public boolean hasRollbackFirstTransaction() {
        for (TransactionTableEntry ent : this.trans.values()) {
            if (ent == null || !ent.isRecovery() || (ent.getTransactionStatus() & 0x10) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasPreparedRecoveredXact() {
        return this.hasPreparedXact(true);
    }

    public boolean hasPreparedXact() {
        return this.hasPreparedXact(false);
    }

    private boolean hasPreparedXact(boolean recovered) {
        for (TransactionTableEntry ent : this.trans.values()) {
            if (ent == null || (ent.getTransactionStatus() & 2) == 0) continue;
            if (recovered) {
                if (!ent.isRecovery()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean getMostRecentRollbackFirstTransaction(RawTransaction tran) {
        if (this.trans.isEmpty()) {
            return this.findAndAssumeTransaction(null, tran);
        }
        TransactionId id = null;
        for (TransactionTableEntry ent : this.trans.values()) {
            if (ent == null || !ent.isUpdate() || !ent.isRecovery() || (ent.getTransactionStatus() & 0x10) == 0 || id != null && XactId.compare(id, ent.getXid()) >= 0L) continue;
            id = ent.getXid();
        }
        if (id == null) {
            return this.findAndAssumeTransaction(id, tran);
        }
        boolean found = this.findAndAssumeTransaction(id, tran);
        if (!found) {
            SanityManager.THROWASSERT("cannot find transaction " + id + " in table");
        }
        return true;
    }

    public boolean getMostRecentTransactionForRollback(RawTransaction tran) {
        TransactionId id = null;
        if (!this.trans.isEmpty()) {
            for (TransactionTableEntry ent : this.trans.values()) {
                if (ent != null && ent.isUpdate() && ent.isRecovery() && !ent.isPrepared() && (id == null || XactId.compare(id, ent.getXid()) < 0L)) {
                    id = ent.getXid();
                }
                if (ent == null || !ent.isUpdate() || !ent.isRecovery() || (ent.getTransactionStatus() & 0x10) == 0) continue;
                SanityManager.THROWASSERT("still rollback first xacts in the tran table!");
            }
            if (id != null) {
                SanityManager.ASSERT(this.findTransactionEntry(id) != null);
            } else {
                for (TransactionTableEntry ent : this.trans.values()) {
                    SanityManager.ASSERT(ent.isPrepared());
                }
            }
        }
        return this.findAndAssumeTransaction(id, tran);
    }

    public boolean getMostRecentPreparedRecoveredXact(RawTransaction tran) {
        TransactionTableEntry found_ent = null;
        if (!this.trans.isEmpty()) {
            TransactionId id = null;
            GlobalTransactionId gid = null;
            for (TransactionTableEntry ent : this.trans.values()) {
                if (ent == null || !ent.isRecovery() || !ent.isPrepared() || id != null && XactId.compare(id, ent.getXid()) >= 0L) continue;
                found_ent = ent;
                id = ent.getXid();
                gid = ent.getGid();
            }
            if (found_ent == null) {
                for (TransactionTableEntry ent : this.trans.values()) {
                    if (XactId.compare(ent.getXid(), tran.getId()) == 0L) continue;
                    SanityManager.ASSERT(!ent.isRecovery() && ent.isPrepared());
                    SanityManager.ASSERT(ent.getGid() != null);
                }
            }
            if (found_ent != null) {
                TransactionTableEntry new_ent = this.trans.remove(tran.getId());
                SanityManager.ASSERT(this.findTransactionEntry(id) == found_ent);
                ((Xact)tran).assumeGlobalXactIdentity(found_ent);
                found_ent.unsetRecoveryStatus();
            }
        }
        return found_ent != null;
    }

    public LogInstant getFirstLogInstant() {
        LogInstant logInstant = null;
        for (TransactionTableEntry entry : this.trans.values()) {
            if (!entry.isUpdate() || logInstant != null && !entry.getFirstLog().lessThan(logInstant)) continue;
            logInstant = entry.getFirstLog();
        }
        return logInstant;
    }

    boolean findAndAssumeTransaction(TransactionId id, RawTransaction tran) {
        TransactionTableEntry ent = null;
        if (id != null && !this.trans.isEmpty() && (ent = this.findTransactionEntry(id)) != null) {
            SanityManager.ASSERT(ent.isRecovery(), "assuming the id of a non-recovery transaction");
        }
        ((Xact)tran).assumeIdentity(ent);
        return ent != null;
    }

    public TransactionInfo[] getTransactionInfo() {
        if (this.trans.isEmpty()) {
            return null;
        }
        SanityManager.DEBUG("TranTrace", this.toString());
        ArrayList<TransactionTableEntry> tinfo = new ArrayList<TransactionTableEntry>();
        for (TransactionTableEntry entry : this.trans.values()) {
            tinfo.add((TransactionTableEntry)entry.clone());
        }
        return tinfo.toArray(new TransactionTableEntry[tinfo.size()]);
    }

    public String toString() {
        StringBuffer str = new StringBuffer(1000).append("\n**************************\n").append(super.toString()).append("\nTransaction Table: size = ").append(this.trans.size()).append(" largestUpdateXactId = ").append(this.largestUpdateXactId).append("\n");
        boolean hasReadOnlyTransaction = false;
        for (TransactionTableEntry entry : this.trans.values()) {
            if (entry.isUpdate()) {
                str.append(entry);
                continue;
            }
            hasReadOnlyTransaction = true;
        }
        if (hasReadOnlyTransaction) {
            str.append("\n READ ONLY TRANSACTIONS \n");
            for (TransactionTableEntry entry : this.trans.values()) {
                if (entry.isUpdate()) continue;
                str.append(entry);
            }
        }
        str.append("---------------------------");
        return str.toString();
    }

    static interface EntryVisitor {
        public boolean visit(TransactionTableEntry var1);
    }
}

