/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.derby.vti.AwareVTI;
import org.apache.derby.vti.ForeignTableVTI;
import org.apache.derby.vti.ForwardingVTI;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;
import org.apache.derby.vti.VTIContext;

public class ArchiveVTI
extends ForwardingVTI
implements AwareVTI,
RestrictedVTI {
    private Connection _connection = DriverManager.getConnection("jdbc:default:connection");
    private String _archiveSuffix;
    private VTIContext _vtiContext;
    private ArrayList<String> _tableNames;
    private int _tableIdx;
    private String[] _columnNames;
    private Restriction _restriction;

    public static ArchiveVTI archiveVTI(String archiveSuffix) throws SQLException {
        return new ArchiveVTI(archiveSuffix);
    }

    public ArchiveVTI(String archiveSuffix) throws SQLException {
        this._archiveSuffix = archiveSuffix;
    }

    public VTIContext getContext() {
        return this._vtiContext;
    }

    public void setContext(VTIContext context) {
        this._vtiContext = context;
    }

    public void initScan(String[] columnNames, Restriction restriction) throws SQLException {
        this._columnNames = new String[columnNames.length];
        System.arraycopy(columnNames, 0, this._columnNames, 0, columnNames.length);
        this._restriction = restriction;
    }

    public boolean next() throws SQLException {
        if (this._tableNames == null) {
            this.getTableNames();
            this._tableIdx = 0;
            this.loadResultSet();
        }
        while (!super.next()) {
            ++this._tableIdx;
            if (this._tableIdx >= this._tableNames.size()) {
                return false;
            }
            this.loadResultSet();
        }
        return true;
    }

    public void close() throws SQLException {
        if (this.getWrappedResultSet() != null) {
            this.getWrappedResultSet().close();
        }
        this.wrapResultSet(null);
        this._connection = null;
    }

    private void getTableNames() throws SQLException {
        this._tableNames = new ArrayList();
        this._tableNames.add(this.getContext().vtiTable());
        DatabaseMetaData dbmd = this.getConnection().getMetaData();
        ResultSet candidates = dbmd.getTables(null, this.getContext().vtiSchema(), this.getContext().vtiTable() + this._archiveSuffix + "%", null);
        while (candidates.next()) {
            this._tableNames.add(candidates.getString("TABLE_NAME"));
        }
        candidates.close();
    }

    private void loadResultSet() throws SQLException {
        if (this.getWrappedResultSet() != null) {
            this.getWrappedResultSet().close();
        }
        ForeignTableVTI nextRS = new ForeignTableVTI(this.getContext().vtiSchema(), this._tableNames.get(this._tableIdx), this.getConnection());
        nextRS.initScan(this._columnNames, this._restriction);
        this.wrapResultSet((ResultSet)nextRS);
    }

    private Connection getConnection() throws SQLException {
        return this._connection;
    }
}

