/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.Table;

public class HmtxTable
implements Table {
    private byte[] buf = null;
    private int[] hMetrics = null;
    private short[] leftSideBearing = null;

    protected HmtxTable(DirectoryEntry directoryEntry, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(directoryEntry.getOffset());
        this.buf = new byte[directoryEntry.getLength()];
        randomAccessFile.read(this.buf);
    }

    public void init(int n, int n2) {
        if (this.buf == null) {
            return;
        }
        this.hMetrics = new int[n];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf);
        int n3 = 0;
        while (n3 < n) {
            this.hMetrics[n3] = byteArrayInputStream.read() << 24 | byteArrayInputStream.read() << 16 | byteArrayInputStream.read() << 8 | byteArrayInputStream.read();
            ++n3;
        }
        if (n2 > 0) {
            this.leftSideBearing = new short[n2];
            int n4 = 0;
            while (n4 < n2) {
                this.leftSideBearing[n4] = (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read());
                ++n4;
            }
        }
        this.buf = null;
    }

    public int getAdvanceWidth(int n) {
        if (this.hMetrics == null) {
            return 0;
        }
        if (n < this.hMetrics.length) {
            return this.hMetrics[n] >> 16;
        }
        return this.hMetrics[this.hMetrics.length - 1] >> 16;
    }

    public short getLeftSideBearing(int n) {
        if (this.hMetrics == null) {
            return 0;
        }
        if (n < this.hMetrics.length) {
            return (short)(this.hMetrics[n] & 0xFFFF);
        }
        return this.leftSideBearing[n - this.hMetrics.length];
    }

    public int getType() {
        return 1752003704;
    }
}

