/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.AuthenticationTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DriverMgrAuthenticationTest
extends AuthenticationTest {
    public DriverMgrAuthenticationTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("DriverManager not available with JSR169;empty DriverMgrAuthenticationTest");
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite("DriverMgrAuthenticationTest");
        baseTestSuite.addTest(DriverMgrAuthenticationTest.baseSuite("DriverMgrAuthenticationTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(DriverMgrAuthenticationTest.baseSuite("DriverMgrAuthenticationTest:client")));
        return baseTestSuite;
    }

    public static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DriverMgrAuthenticationTest");
        DriverMgrAuthenticationTest driverMgrAuthenticationTest = new DriverMgrAuthenticationTest("testConnectShutdownAuthentication");
        DriverMgrAuthenticationTest.setBaseProps(baseTestSuite, (Test)driverMgrAuthenticationTest);
        driverMgrAuthenticationTest = new DriverMgrAuthenticationTest("testUserFunctions");
        DriverMgrAuthenticationTest.setBaseProps(baseTestSuite, (Test)driverMgrAuthenticationTest);
        driverMgrAuthenticationTest = new DriverMgrAuthenticationTest("testNotFullAccessUsers");
        DriverMgrAuthenticationTest.setBaseProps(baseTestSuite, (Test)driverMgrAuthenticationTest);
        driverMgrAuthenticationTest = new DriverMgrAuthenticationTest("testChangePasswordAndDatabasePropertiesOnly");
        DriverMgrAuthenticationTest.setBaseProps(baseTestSuite, (Test)driverMgrAuthenticationTest);
        driverMgrAuthenticationTest = new DriverMgrAuthenticationTest("testGreekCharacters");
        DriverMgrAuthenticationTest.setBaseProps(baseTestSuite, (Test)driverMgrAuthenticationTest);
        driverMgrAuthenticationTest = new DriverMgrAuthenticationTest("testSystemShutdown");
        DriverMgrAuthenticationTest.setBaseProps(baseTestSuite, (Test)driverMgrAuthenticationTest);
        return TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite);
    }

    @Override
    protected void assertConnectionOK(String string, String string2, String string3) throws SQLException {
        String string4 = TestConfiguration.getCurrent().getJDBCUrl(string);
        DriverManager.getConnection(string4, string2, string3).close();
    }

    @Override
    protected void assertConnectionWOUPOK(String string, String string2, String string3) throws SQLException {
        String string4 = TestConfiguration.getCurrent().getJDBCUrl(string);
        String string5 = string4 + ";user=" + string2 + ";password=" + string3;
        DriverManager.getConnection(string5).close();
    }

    @Override
    protected void assertConnectionFail(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = TestConfiguration.getCurrent().getJDBCUrl(string2);
        try {
            DriverManager.getConnection(string5, string3, string4);
            DriverMgrAuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException sQLException) {
            DriverMgrAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    protected void assertConnectionWOUPFail(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = TestConfiguration.getCurrent().getJDBCUrl(string2);
        String string6 = string5 + ";user=" + string3 + ";password=" + string4;
        try {
            DriverManager.getConnection(string6);
            DriverMgrAuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException sQLException) {
            DriverMgrAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    protected void assertShutdownOK(String string, String string2, String string3) throws SQLException {
        String string4 = TestConfiguration.getCurrent().getJDBCUrl(string) + ";shutdown=true";
        try {
            DriverManager.getConnection(string4, string2, string3);
            DriverMgrAuthenticationTest.fail((String)"expected a failed shutdown connection");
        }
        catch (SQLException sQLException) {
            DriverMgrAuthenticationTest.assertSQLState("08006", sQLException);
        }
    }

    @Override
    protected void assertShutdownWOUPOK(String string, String string2, String string3) throws SQLException {
        Object object = TestConfiguration.getCurrent().getJDBCUrl(string);
        object = (String)object + ";shutdown=true;user=" + string2 + ";password=" + string3;
        try {
            DriverManager.getConnection((String)object, null);
            DriverMgrAuthenticationTest.fail((String)"expected a error after shutdown connection");
        }
        catch (SQLException sQLException) {
            DriverMgrAuthenticationTest.assertSQLState("08006", sQLException);
        }
    }

    @Override
    protected void assertShutdownFail(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = TestConfiguration.getCurrent().getJDBCUrl(string2) + ";shutdown=true";
        try {
            DriverManager.getConnection(string5, string3, string4);
            DriverMgrAuthenticationTest.fail((String)"expected failed shutdown");
        }
        catch (SQLException sQLException) {
            DriverMgrAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    protected void assertShutdownWOUPFail(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = TestConfiguration.getCurrent().getJDBCUrl(string2);
        String string6 = string5 + ";user=" + string3 + ";password=" + string4 + ";shutdown=true";
        try {
            DriverManager.getConnection(string6);
            DriverMgrAuthenticationTest.fail((String)"expected failed shutdown");
        }
        catch (SQLException sQLException) {
            DriverMgrAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    protected void assertSystemShutdownOK(String string, String string2, String string3) throws SQLException {
        String string4 = TestConfiguration.getCurrent().getJDBCUrl(string);
        if (DriverMgrAuthenticationTest.usingDerbyNetClient() && string == "") {
            return;
        }
        String string5 = string4 + ";user=" + string2 + ";password=" + string3 + ";shutdown=true";
        try {
            DriverManager.getConnection(string5);
            DriverMgrAuthenticationTest.fail((String)"expected successful shutdown");
        }
        catch (SQLException sQLException) {
            DriverMgrAuthenticationTest.assertSQLState("XJ015", sQLException);
        }
    }

    @Override
    protected void assertSystemShutdownFail(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = TestConfiguration.getCurrent().getJDBCUrl(string2);
        if (DriverMgrAuthenticationTest.usingDerbyNetClient() && string2 == "") {
            return;
        }
        String string6 = string5 + ";user=" + string3 + ";password=" + string4 + ";shutdown=true";
        try {
            DriverManager.getConnection(string6);
            DriverMgrAuthenticationTest.fail((String)"expected failed shutdown");
        }
        catch (SQLException sQLException) {
            DriverMgrAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    public void assertConnectionFail(String string) throws SQLException {
        String string2 = TestConfiguration.getCurrent().getJDBCUrl(string);
        try {
            DriverManager.getConnection(string2);
            DriverMgrAuthenticationTest.fail((String)"expected connection to fail");
        }
        catch (SQLException sQLException) {
            DriverMgrAuthenticationTest.assertSQLState("08004", sQLException);
        }
    }
}

