/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class WISCInsert {
    private static final char[] chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    int numrows;
    int prime;
    int generator;
    int rowsReturned = 0;
    int unique1;
    int unique2;
    int two;
    int four;
    int ten;
    int twenty;
    int onePercent;
    int tenPercent;
    int twentyPercent;
    int fiftyPercent;
    int unique3;
    int evenOnePercent;
    int oddOnePercent;
    String stringu1;
    String stringu2;
    String string4;
    int seed;
    static final String[] cyclicStrings = new String[]{"AAAAxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "HHHHxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "OOOOxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "VVVVxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"};
    boolean closed = false;

    public int doWISCInsert(int n, String string, Connection connection) throws SQLException {
        this.numrows = n;
        if (n <= 1000) {
            this.generator = 279;
            this.prime = 1009;
        } else if (n <= 10000) {
            this.generator = 2969;
            this.prime = 10007;
        } else if (n <= 100000) {
            this.generator = 21395;
            this.prime = 100003;
        } else if (n <= 1000000) {
            this.generator = 2107;
            this.prime = 1000003;
        } else if (n <= 10000000) {
            this.generator = 211;
            this.prime = 10000019;
        } else if (n <= 100000000) {
            this.generator = 21;
            this.prime = 100000007;
        } else {
            throw new SQLException("Too many rows - maximum is 100000000, " + n + " requested.");
        }
        this.seed = this.generator;
        String string2 = "insert into " + string + " values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (int i = 0; i < n; ++i) {
            this.next();
            preparedStatement.setInt(1, this.unique1);
            preparedStatement.setInt(2, this.unique2);
            preparedStatement.setInt(3, this.two);
            preparedStatement.setInt(4, this.four);
            preparedStatement.setInt(5, this.ten);
            preparedStatement.setInt(6, this.twenty);
            preparedStatement.setInt(7, this.onePercent);
            preparedStatement.setInt(8, this.tenPercent);
            preparedStatement.setInt(9, this.twentyPercent);
            preparedStatement.setInt(10, this.fiftyPercent);
            preparedStatement.setInt(11, this.unique3);
            preparedStatement.setInt(12, this.evenOnePercent);
            preparedStatement.setInt(13, this.oddOnePercent);
            preparedStatement.setString(14, this.stringu1);
            preparedStatement.setString(15, this.stringu2);
            preparedStatement.setString(16, this.string4);
            preparedStatement.executeUpdate();
        }
        return n;
    }

    public boolean next() throws SQLException {
        if (this.rowsReturned >= this.numrows) {
            return false;
        }
        this.seed = this.rand(this.seed, this.numrows);
        this.unique1 = this.seed - 1;
        this.unique2 = this.rowsReturned;
        this.two = this.unique1 % 2;
        this.four = this.unique1 % 4;
        this.ten = this.unique1 % 10;
        this.twenty = this.unique1 % 20;
        this.onePercent = this.unique1 % 100;
        this.tenPercent = this.unique1 % 10;
        this.twentyPercent = this.unique1 % 5;
        this.fiftyPercent = this.unique1 % 2;
        this.unique3 = this.unique1;
        this.evenOnePercent = this.onePercent * 2;
        this.oddOnePercent = this.evenOnePercent + 1;
        this.stringu1 = this.uniqueString(this.unique1);
        this.stringu2 = this.uniqueString(this.unique2);
        this.string4 = cyclicStrings[this.rowsReturned % cyclicStrings.length];
        ++this.rowsReturned;
        return true;
    }

    private int rand(int n, int n2) {
        while ((n = this.generator * n % this.prime) > n2) {
        }
        return n;
    }

    private String uniqueString(int n) {
        int n2;
        char[] cArray = new char[52];
        for (n2 = 0; n2 < 7; ++n2) {
            cArray[n2] = 65;
        }
        for (n2 = 7; n2 < cArray.length; ++n2) {
            cArray[n2] = 120;
        }
        n2 = 6;
        while (n > 0) {
            int n3 = n % 26;
            cArray[n2] = chars[n3];
            n /= 26;
            --n2;
        }
        return new String(cArray);
    }

    public String getShortTestDescription() {
        StringBuffer stringBuffer = new StringBuffer("insert values into wisconsin benchmark schema.");
        stringBuffer.append("See The Benchmark Handbook, Second Edition (edited by Jim Gray).");
        return stringBuffer.toString();
    }

    public String getLongTestDescription() {
        StringBuffer stringBuffer = new StringBuffer(this.getShortTestDescription() + "\n Called from performance.wisc.WiscLoad. This is not actually a test itself. Based on a scale value by which to multiply the number of rows, the values are generated. This class is based on the vti org.apache.derbyTesting.functionTests.tests.lang.Wisc, however, this will work with any database, not just Cloudscape.");
        return stringBuffer.toString();
    }

    public boolean isCloudscapeSpecificTest() {
        return false;
    }
}

