/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UnaryArithmeticParameterTest
extends BaseJDBCTestCase {
    public UnaryArithmeticParameterTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (!JDBC.vmSupportsJDBC3()) {
            return new BaseTestSuite("empty UnaryArithmeticParameterTest - supported only from JDBC3.0 and above");
        }
        return TestConfiguration.defaultSuite(UnaryArithmeticParameterTest.class);
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1 (c11 int, c12 smallint, c13 double, c14 char(3))");
        statement.execute("insert into t1 values(1,1,1.1,'abc')");
        statement.execute("insert into t1 values(-1,-1,-1.0,'def')");
        statement.execute("create table t2 (c21 int)");
        statement.execute("insert into t2 values (-1),(-2)");
        statement.close();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("drop table t1");
        statement.executeUpdate("drop table t2");
        statement.close();
        this.commit();
        super.tearDown();
    }

    public void testParametersForUnaryMinusAndPlus() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values(?,+?,-?,?)");
        preparedStatement.setInt(1, 3);
        preparedStatement.setInt(2, 3);
        preparedStatement.setDouble(3, -3.1);
        preparedStatement.setString(4, "ghi");
        int[] nArray = new int[]{4, 5, 8, 1};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, -1);
        preparedStatement.setInt(2, -1);
        preparedStatement.setDouble(3, 1.0);
        preparedStatement.setString(4, "jkl");
        preparedStatement.executeUpdate();
        preparedStatement = this.prepareStatement("select * from t1 where -? in (select c21 from t2)");
        preparedStatement.setInt(1, 1);
        nArray = new int[]{4};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        Object[][] objectArray = new Object[][]{{1, 1, 1.1, new String("abc")}, {-1, -1, -1.0, new String("def")}, {3, 3, 3.1, new String("ghi")}, {-1, -1, -1.0, new String("jkl")}};
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement = this.prepareStatement("select * from t1 where c11 = -? and c12 = +? and c13 = ?");
        preparedStatement.setInt(1, -1);
        preparedStatement.setInt(2, 1);
        preparedStatement.setDouble(3, 1.1);
        nArray = new int[]{4, 5, 8};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        objectArray = new Object[][]{{1, 1, 1.1, new String("abc")}};
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement.setShort(1, (short)1);
        preparedStatement.setInt(2, -1);
        preparedStatement.setInt(3, -1);
        objectArray = new Object[][]{{-1, -1, -1.0, new String("def")}, {-1, -1, -1.0, new String("jkl")}};
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement.close();
    }

    public void testABSWithUnaryMinusAndPlus() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("CREATE FUNCTION ABS_FUNCT(P1 INT) RETURNS INT CALLED ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 where -? = abs_funct(+?)");
        preparedStatement.setInt(1, -1);
        preparedStatement.setInt(2, 1);
        int[] nArray = new int[]{4, 4};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        Object[][] objectArray = new Object[][]{{1, 1, 1.1, new String("abc")}, {-1, -1, -1.0, new String("def")}};
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement.close();
        statement.execute("Drop function ABS_FUNCT");
        statement.close();
    }

    public void testMAXWithUnaryMinusAndPlus() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("CREATE FUNCTION MAX_CNI(P1 INT, P2 INT) RETURNS INT CALLED ON NULL INPUT EXTERNAL NAME 'java.lang.Math.max' LANGUAGE JAVA PARAMETER STYLE JAVA");
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 where -? = max_cni(-5,-1)");
        preparedStatement.setInt(1, 1);
        int[] nArray = new int[]{4};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        Object[][] objectArray = new Object[][]{{1, 1, 1.1, new String("abc")}, {-1, -1, -1.0, new String("def")}};
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement = this.prepareStatement("select * from t1 where -? = max_cni(-?,+?)");
        preparedStatement.setInt(1, -1);
        preparedStatement.setInt(2, 1);
        preparedStatement.setInt(3, 1);
        nArray = new int[]{4, 4, 4};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement = this.prepareStatement("select * from t1 where -? = max_cni(abs(-?), sqrt(+?))");
        preparedStatement.setInt(1, -2);
        preparedStatement.setInt(2, 1);
        preparedStatement.setInt(3, 4);
        nArray = new int[]{4, 8, 8};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement.close();
        statement.execute("Drop function MAX_CNI");
        statement.close();
    }

    public void testBETWEENWithUnaryMinusAndPlus() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 where c11 between -? and +?");
        preparedStatement.setInt(1, -1);
        preparedStatement.setInt(2, 1);
        int[] nArray = new int[]{4, 4};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        Object[][] objectArray = new Object[][]{{1, 1, 1.1, new String("abc")}};
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement.close();
    }

    public void testNOTINWithUnaryMinusAndPlus() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 where +? not in (-?, +?, 2, ?)");
        preparedStatement.setInt(1, -11);
        preparedStatement.setInt(2, 1);
        preparedStatement.setInt(3, 1);
        preparedStatement.setInt(4, 4);
        int[] nArray = new int[]{4, 4, 4, 4};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        Object[][] objectArray = new Object[][]{{1, 1, 1.1, new String("abc")}, {-1, -1, -1.0, new String("def")}};
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement = this.prepareStatement("select * from t1 where -? not in (select c21+? from t2)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 2);
        nArray = new int[]{4, 4};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement.close();
    }

    public void testOperatorsWithUnaryMinusAndPlus() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 where +? < c12");
        preparedStatement.setInt(1, 0);
        int[] nArray = new int[]{5};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        Object[][] objectArray = new Object[][]{{1, 1, 1.1, new String("abc")}};
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement = this.prepareStatement("select * from t1 where -? = c11 + ?");
        preparedStatement.setInt(1, 2);
        preparedStatement.setInt(2, -1);
        nArray = new int[]{4, 4};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        objectArray = new Object[][]{{-1, -1, -1.0, new String("def")}};
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement = this.prepareStatement("select * from t1 where c11 + ? = -?");
        preparedStatement.setInt(1, -1);
        preparedStatement.setInt(2, 2);
        JDBC.assertParameterTypes(preparedStatement, nArray);
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement = this.prepareStatement("select * from t1 where c11 + c12 = -?");
        preparedStatement.setInt(1, 2);
        nArray = new int[]{4};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement.close();
    }

    public void testCastWithUnaryMinusAndPlus() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("select cast(-? as smallint), cast(+? as int) from t1");
        preparedStatement.setInt(1, 2);
        preparedStatement.setInt(2, 2);
        int[] nArray = new int[]{5, 4};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        Object[][] objectArray = new String[][]{{"-2", "2"}, {"-2", "2"}};
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, true);
        preparedStatement.close();
    }

    public void testNullIfWithUnaryMinusAndPlus() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("select nullif(-?,c11) from t1");
        preparedStatement.setInt(1, 22);
        int[] nArray = new int[]{4};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        Object[][] objectArray = new Object[][]{{new String("-22")}, {new String("-22")}};
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, true);
        preparedStatement.close();
    }

    public void testSQRTWithUnaryMinusAndPlus() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("select sqrt(-?) from t1");
        preparedStatement.setInt(1, -64);
        int[] nArray = new int[]{8};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        Object[][] objectArray = new Object[][]{{new String("8.0")}, {new String("8.0")}};
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, true);
        preparedStatement.close();
    }

    public void testSelectWithUnaryMinusAndPlus() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("select case when -?=c11 then -? else c12 end from t1");
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 22);
        int[] nArray = new int[]{4, 5};
        JDBC.assertParameterTypes(preparedStatement, nArray);
        Object[][] objectArray = new Object[][]{{1}, {-22}};
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        preparedStatement.close();
    }

    public void testExpectedErrors() throws Exception {
        this.assertCompileError("42X34", "select * from t1 where c11 = any (select -? from t2)");
        this.assertCompileError("42X19", "select * from t1 where -? and c11=c11 or +?");
        this.assertCompileError("42X37", "select * from sys.systables where tablename like -? escape +?");
        this.assertCompileError("42X37", "select timestamp(-?,+?) from t1");
        this.assertCompileError("42X36", "select timestamp(-?) from t1");
        this.assertCompileError("42X98", "create view v1 as select * from t1 where c11 = -?");
        this.assertCompileError("42X37", "select * from t1 inner join t1 as t333 on -?");
        this.assertCompileError("42X19", "select * from t1 where -?");
        this.assertCompileError("42X37", "select * from t1 where -? is null");
        this.assertCompileError("42X35", "select * from t1 where c11 = ?/-?");
        this.assertCompileError("42X37", "select c11 || +? from t1");
        this.assertCompileError("42X37", "select * from t1 where c14 = -?");
        this.assertCompileError("42X37", "select * from t1 where c14 like +?");
    }
}

