/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.jdbc;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.jdbc.SchemaType;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceException;
import org.apache.torque.generator.source.SourceImpl;
import org.apache.torque.generator.source.jdbc.ColumnMetadata;
import org.apache.torque.generator.source.jdbc.ForeignKeyMetadata;

public class JdbcMetadataSource
extends SourceImpl {
    private static final int TABLE_NAME_POS_IN_TABLE_METADATA = 3;
    private static final int COLUMN_NAME_POS_IN_COLUMN_METADATA = 4;
    private static final int DATA_TYPE_POS_COLUMN_METADATA = 5;
    private static final int COLUMN_SIZE_POS_IN_COLUMN_METADATA = 7;
    private static final int DECIMAL_DIGITS_POS_IN_COLUMN_METADATA = 9;
    private static final int NULLABLE_POS_IN_COLUMN_METADATA = 11;
    private static final int DEFAULT_VALUE_POS_IN_COLUMN_METADATA = 13;
    private static final int COLUMN_NAME_POS_IN_PRIMARY_KEY_METADATA = 4;
    private static final int TABLE_NAME_POS_IN_FOREIGN_KEY_METADATA = 3;
    private static final int FOREIGN_COLUMN_NAME_POS_IN_FOREIGN_KEY_METADATA = 4;
    private static final int LOCAL_COLUMN_NAME_POS_IN_FOREIGN_KEY_METADATA = 8;
    private static final int FOREIGN_KEY_NAME_POS_IN_FOREIGN_KEY_METADATA = 12;
    private static Log log = LogFactory.getLog(JdbcMetadataSource.class);
    private final String driver;
    private final String url;
    private final String username;
    private final String password;
    private final String schema;

    public JdbcMetadataSource(String driver, String url, String username, String password, String schema) {
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
        this.schema = schema;
    }

    @Override
    protected SourceElement createRootElement() throws SourceException {
        SourceElement rootElement = new SourceElement("database");
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new SourceException("Could not find database driver class " + this.driver, e);
        }
        log.debug((Object)("DB driver " + this.driver + " loaded"));
        try (Connection con = DriverManager.getConnection(this.url, this.username, this.password);){
            log.debug((Object)("DB connection to database " + this.url + " established"));
            DatabaseMetaData dbMetaData = con.getMetaData();
            List<String> tableList = this.getTableNames(dbMetaData, this.schema);
            for (int i = 0; i < tableList.size(); ++i) {
                String tableName = tableList.get(i);
                log.debug((Object)("Processing table: " + tableName));
                SourceElement table = new SourceElement("table");
                rootElement.getChildren().add(table);
                table.setAttribute("name", (Object)tableName);
                List<ColumnMetadata> columns = this.getColumns(dbMetaData, tableName, this.schema);
                Set<String> primaryKeys = this.getPrimaryKeys(dbMetaData, tableName, this.schema);
                for (ColumnMetadata col : columns) {
                    String name = col.getName();
                    Integer type = col.getSqlType();
                    int size = col.getSize();
                    int scale = col.getDecimalDigits();
                    Integer nullType = col.getNullType();
                    String defValue = col.getDefValue();
                    SourceElement column = new SourceElement("column");
                    column.setAttribute("name", (Object)name);
                    SchemaType schemaType = SchemaType.getByJdbcType(type);
                    if (schemaType != null) {
                        column.setAttribute("type", (Object)schemaType.toString());
                    }
                    if (size > 0 && (type == 1 || type == 12 || type == -1 || type == 3 || type == 2)) {
                        column.setAttribute("size", (Object)String.valueOf(size));
                    }
                    if (scale > 0 && (type == 3 || type == 2)) {
                        column.setAttribute("scale", (Object)String.valueOf(scale));
                    }
                    if (primaryKeys.contains(name)) {
                        column.setAttribute("primaryKey", (Object)"true");
                    } else if (nullType == 0) {
                        column.setAttribute("required", (Object)"true");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)defValue)) {
                        if (defValue.startsWith("(") && defValue.endsWith(")")) {
                            defValue = defValue.substring(1, defValue.length() - 1);
                        }
                        if (defValue.startsWith("'") && defValue.endsWith("'")) {
                            defValue = defValue.substring(1, defValue.length() - 1);
                        }
                        column.setAttribute("default", (Object)defValue);
                    }
                    table.getChildren().add(column);
                }
                Collection<ForeignKeyMetadata> forgnKeys = this.getForeignKeys(dbMetaData, tableName, this.schema);
                for (ForeignKeyMetadata foreignKeyMetadata : forgnKeys) {
                    SourceElement fk = new SourceElement("foreign-key");
                    fk.setAttribute("foreignTable", (Object)foreignKeyMetadata.getReferencedTable());
                    for (int m = 0; m < foreignKeyMetadata.getLocalColumns().size(); ++m) {
                        SourceElement ref = new SourceElement("reference");
                        ref.setAttribute("local", (Object)foreignKeyMetadata.getLocalColumns().get(m));
                        ref.setAttribute("foreign", (Object)foreignKeyMetadata.getForeignColumns().get(m));
                        fk.getChildren().add(ref);
                    }
                    table.getChildren().add(fk);
                }
            }
        }
        catch (SQLException e) {
            throw new SourceException("Could not retrieve JDBC Metadata from url " + this.url, e);
        }
        return rootElement;
    }

    @Override
    public String getDescription() {
        return "JdbcMetadataSource using url " + this.url;
    }

    @Override
    public File getSourceFile() {
        return null;
    }

    List<String> getTableNames(DatabaseMetaData dbMeta, String dbSchema) throws SQLException {
        log.debug((Object)"Getting table list...");
        ArrayList<String> tables = new ArrayList<String>();
        String[] types = new String[]{"TABLE", "VIEW"};
        try (ResultSet tableNames = dbMeta.getTables(null, dbSchema, "%", types);){
            while (tableNames.next()) {
                String name = tableNames.getString(3);
                tables.add(name);
            }
        }
        return tables;
    }

    List<ColumnMetadata> getColumns(DatabaseMetaData dbMeta, String tableName, String dbSchema) throws SQLException {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
        try (ResultSet columnSet = dbMeta.getColumns(null, dbSchema, tableName, null);){
            while (columnSet.next()) {
                String name = columnSet.getString(4);
                Integer sqlType = Integer.valueOf(columnSet.getString(5));
                Integer size = columnSet.getInt(7);
                Integer decimalDigits = columnSet.getInt(9);
                Integer nullType = columnSet.getInt(11);
                String defValue = columnSet.getString(13);
                ColumnMetadata column = new ColumnMetadata(name, sqlType, size, nullType, defValue, decimalDigits);
                columns.add(column);
            }
        }
        return columns;
    }

    Set<String> getPrimaryKeys(DatabaseMetaData dbMeta, String tableName, String schemaName) throws SQLException {
        HashSet<String> pk = new HashSet<String>();
        try (ResultSet parts = dbMeta.getPrimaryKeys(null, schemaName, tableName);){
            while (parts.next()) {
                pk.add(parts.getString(4));
            }
        }
        return pk;
    }

    Collection<ForeignKeyMetadata> getForeignKeys(DatabaseMetaData dbMeta, String tableName, String schemaName) throws SQLException {
        HashMap<String, ForeignKeyMetadata> foreignKeys = new HashMap<String, ForeignKeyMetadata>();
        try (ResultSet resultSet = dbMeta.getImportedKeys(null, schemaName, tableName);){
            while (resultSet.next()) {
                ForeignKeyMetadata fk;
                String refTableName = resultSet.getString(3);
                String fkName = resultSet.getString(12);
                if (fkName == null) {
                    fkName = refTableName;
                }
                if ((fk = (ForeignKeyMetadata)foreignKeys.get(fkName)) == null) {
                    fk = new ForeignKeyMetadata();
                    fk.setReferencedTable(refTableName);
                    fk.setForeignKeyName(fkName);
                    foreignKeys.put(fkName, fk);
                }
                fk.getLocalColumns().add(resultSet.getString(8));
                fk.getForeignColumns().add(resultSet.getString(4));
            }
        }
        catch (SQLException e) {
            log.warn((Object)("WARN: Could not read foreign keys for Table " + tableName + " : " + e.getMessage()));
        }
        return foreignKeys.values();
    }

    @Override
    public Date getLastModified() {
        return null;
    }

    @Override
    public byte[] getContentChecksum() {
        return null;
    }
}

