/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.variable;

import org.apache.torque.generator.qname.QualifiedName;

public class Variable {
    private QualifiedName name;
    private Object value;
    private Scope scope;

    public Variable(QualifiedName name, Object value, Scope scope) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (scope == null) {
            throw new NullPointerException("scope must not be null");
        }
        this.name = name;
        this.value = value;
        this.scope = scope;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Scope getScope() {
        return this.scope;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Variable other = (Variable)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals((Object)other.scope)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("(name=").append(this.name).append(", value=").append(this.value).append(", scope=").append((Object)this.scope).append(")");
        return result.toString();
    }

    public static enum Scope {
        OUTLET,
        CHILDREN,
        FILE,
        GLOBAL;

    }
}

