/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.controls;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitControls
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitControls.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitControls() {
        super("Initialize a control");
    }

    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        int expectedLength = tlv.getLength();
        if (expectedLength != 0) {
            if (IS_DEBUG) {
                LOG.debug("A new list of controls has been initialized");
            }
        } else if (IS_DEBUG) {
            LOG.debug("An empty list of controls has been initialized");
        }
        container.setGrammarEndAllowed(true);
    }
}

