/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.substrate.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.atomos.utils.substrate.api.NativeImageArguments;
import org.apache.felix.atomos.utils.substrate.impl.BaseNativeImageArguments;

public class NativeImageCliUtil {
    private static final String GRAAL_HOME = "GRAAL_HOME";
    private static final String JAVA_HOME = "java.home";

    public static Path execute(Path outputDir, BaseNativeImageArguments arguments) throws Exception {
        return NativeImageCliUtil.execute(null, outputDir, arguments);
    }

    public static Path execute(Path nativeImageExec, Path executionDir, NativeImageArguments arguments) throws Exception {
        Optional<Path> exec = NativeImageCliUtil.findNativeImageExecutable(nativeImageExec);
        if (exec.isEmpty()) {
            throw new Exception("Missing native image executable. Set 'GRAAL_HOME' with the path as an environment variable");
        }
        Path resultFile = executionDir.resolve(arguments.name());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(exec.get().toAbsolutePath().toString());
        commands.addAll(arguments.arguments());
        ProcessBuilder pB = new ProcessBuilder(commands);
        pB.inheritIO();
        pB.directory(executionDir.toFile());
        String cmds = pB.command().stream().collect(Collectors.joining(" "));
        System.out.println(cmds);
        Process process = pB.start();
        int exitValue = process.waitFor();
        if (exitValue != 0) {
            throw new Exception("native-image returns exit value: " + exitValue);
        }
        if (Files.exists(resultFile, new LinkOption[0])) {
            return resultFile;
        }
        throw new Exception("native-image could not be found: " + resultFile.toAbsolutePath().toString());
    }

    public static Optional<Path> findNativeImageExecutable() {
        return NativeImageCliUtil.findNativeImageExecutable(null);
    }

    public static Optional<Path> findNativeImageExecutable(Path path) {
        if (path == null) {
            Optional<Path> oExec = NativeImageCliUtil.findNativeImageExecutable(Paths.get("native-image", new String[0]));
            if (oExec.isPresent()) {
                return oExec;
            }
            if (System.getenv(GRAAL_HOME) != null && (oExec = NativeImageCliUtil.findNativeImageExecutable(Paths.get(System.getenv(GRAAL_HOME), new String[0]))).isPresent()) {
                return oExec;
            }
            if (System.getProperty(JAVA_HOME) != null && (oExec = NativeImageCliUtil.findNativeImageExecutable(Paths.get(System.getProperty(JAVA_HOME), new String[0]))).isPresent()) {
                return oExec;
            }
            return Optional.empty();
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return Optional.empty();
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            Optional<Path> candidate = NativeImageCliUtil.findNativeImageExecutable(path.resolve("native-image"));
            if (candidate.isPresent()) {
                return candidate;
            }
            return NativeImageCliUtil.findNativeImageExecutable(path.resolve("bin"));
        }
        String version = NativeImageCliUtil.getVersion(path);
        if (version != null) {
            return Optional.of(path);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion(Path exec) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(exec.toString(), "--version");
            Process versionProcess = processBuilder.start();
            try (Stream<String> lines = new BufferedReader(new InputStreamReader(versionProcess.getInputStream())).lines();){
                Optional<String> versionLine = lines.filter(l -> l.contains("GraalVM Version")).findFirst();
                if (!versionLine.isPresent()) return null;
                String string = versionLine.get();
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

