/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deployment.rp.autoconf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class AutoConfResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String m_pid;
    private final String m_factoryPid;
    private final Dictionary m_properties;
    private final String m_bundleLoc;
    private final boolean m_merge;
    private final String m_name;
    private transient Filter m_filter;
    private String m_alias = null;

    public AutoConfResource(String name, String pid, String factoryPid, String bundleLocation, boolean merge, Dictionary properties, Filter filter) {
        this.m_name = name;
        this.m_pid = pid;
        this.m_filter = filter;
        this.m_factoryPid = factoryPid == null ? "" : factoryPid;
        this.m_bundleLoc = bundleLocation;
        this.m_merge = merge;
        this.m_properties = properties;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPid() {
        return this.m_pid;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public String getFactoryPid() {
        return this.m_factoryPid;
    }

    public Dictionary getProperties() {
        return this.m_properties;
    }

    public String getBundleLocation() {
        return this.m_bundleLoc;
    }

    public boolean isMerge() {
        return this.m_merge;
    }

    public boolean isFactoryConfig() {
        return this.m_factoryPid != null && !"".equals(this.m_factoryPid);
    }

    public void setGeneratedPid(String alias) {
        this.m_alias = alias;
    }

    public String getGeneratedPid() {
        if (this.m_alias == null) {
            throw new IllegalStateException("Must set an alias first.");
        }
        return this.m_alias;
    }

    public boolean equalsTargetConfiguration(AutoConfResource resource) {
        if (this.isFactoryConfig()) {
            return this.m_pid.equals(resource.getPid()) && this.m_factoryPid.equals(resource.getFactoryPid());
        }
        return this.m_pid.equals(resource.getPid());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.m_filter != null) {
            out.writeUTF(this.m_filter.toString());
        } else {
            out.writeUTF("");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String filter = in.readUTF();
        if (!"".equals(filter)) {
            try {
                this.m_filter = FrameworkUtil.createFilter((String)filter);
            }
            catch (InvalidSyntaxException e) {
                throw new IOException("Unable to parse serialized filter: " + e.getMessage());
            }
        }
    }
}

