/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks;

import java.io.File;
import java.util.Arrays;
import org.apache.felix.hc.annotation.HealthCheckService;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HealthCheckService(name="Disk Space")
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=Config.class, factory=true)
public class DiskSpaceCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(DiskSpaceCheck.class);
    public static final String HC_NAME = "Disk Space";
    public static final String HC_LABEL = "Health Check: Disk Space";
    private long diskUsedThresholdWarn;
    private long diskUsedThresholdCritical;
    private String[] diskPaths;

    @Activate
    protected void activate(Config config) {
        this.diskUsedThresholdWarn = config.diskUsedThresholdWarn();
        this.diskUsedThresholdCritical = config.diskUsedThresholdCritical();
        this.diskPaths = config.diskPaths();
        LOG.debug("Activated disk usage HC for path(s) {} diskUsedThresholdWarn={}% diskUsedThresholdCritical={}%", new Object[]{Arrays.asList(this.diskPaths), this.diskUsedThresholdWarn, this.diskUsedThresholdCritical});
    }

    public Result execute() {
        FormattingResultLog log = new FormattingResultLog();
        for (String diskPath : this.diskPaths) {
            File diskPathFile = new File(diskPath);
            if (!diskPathFile.exists()) {
                log.warn("Directory '{}' does not exist", new Object[]{diskPathFile});
                continue;
            }
            if (!diskPathFile.isDirectory()) {
                log.warn("Directory '{}' is not a directory", new Object[]{diskPathFile});
                continue;
            }
            double total = diskPathFile.getTotalSpace();
            double free = diskPathFile.getUsableSpace();
            double usedPercentage = (total - free) / total * 100.0;
            String totalStr = FormattingResultLog.bytesHumanReadable((double)total);
            String freeStr = FormattingResultLog.bytesHumanReadable((double)free);
            String msg = String.format("Disk Usage %s: %.1f%% of %s used / %s free", diskPathFile.getAbsolutePath(), usedPercentage, totalStr, freeStr);
            Result.Status status = usedPercentage > (double)this.diskUsedThresholdCritical ? Result.Status.CRITICAL : (usedPercentage > (double)this.diskUsedThresholdWarn ? Result.Status.WARN : Result.Status.OK);
            log.add(new ResultLog.Entry(status, msg));
        }
        return new Result((ResultLog)log);
    }

    @ObjectClassDefinition(name="Health Check: Disk Space", description="Checks the configured path(s) against the given thresholds")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="Name of this health check")
        public String hc_name() default "Disk Space";

        @AttributeDefinition(name="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check.")
        public String[] hc_tags() default {};

        @AttributeDefinition(name="Disk used threshold for WARN", description="in percent, if disk usage is over this limit the result is WARN")
        public long diskUsedThresholdWarn() default 90L;

        @AttributeDefinition(name="Disk used threshold for CRITICAL", description="in percent, if disk usage is over this limit the result is CRITICAL")
        public long diskUsedThresholdCritical() default 97L;

        @AttributeDefinition(name="Paths to check for disk usage", description="Paths that is checked for free space according the configured thresholds")
        public String[] diskPaths() default {"."};

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "{hc.name}: {diskPaths} used>{diskUsedThresholdWarn}% -> WARN  used>{diskUsedThresholdCritical}% -> CRITICAL";
    }
}

