/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks.scrutil;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.rootcause.DSComp;
import org.apache.felix.rootcause.DSRootCause;
import org.apache.felix.rootcause.RootCausePrinter;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;

public class DsRootCauseAdapter {
    private DSRootCause analyzer;

    public DsRootCauseAdapter(ServiceComponentRuntime scr) {
        this.analyzer = new DSRootCause(scr);
    }

    public void logMissingService(FormattingResultLog log, String missingServiceName, Collection<ComponentDescriptionDTO> componentDescriptionDTOs) {
        Optional rootCauseOptional = this.analyzer.getRootCause(missingServiceName, componentDescriptionDTOs);
        if (rootCauseOptional.isPresent()) {
            this.logRootCause(log, (DSComp)rootCauseOptional.get());
        } else {
            log.info("Missing service without matching DS component: " + missingServiceName, new Object[0]);
        }
    }

    public void logNotEnabledComponent(FormattingResultLog log, ComponentDescriptionDTO desc, Collection<ComponentDescriptionDTO> componentDescriptionDTOs) {
        DSComp component = this.analyzer.getRootCause(desc, componentDescriptionDTOs);
        this.logRootCause(log, component);
    }

    private void logRootCause(final FormattingResultLog log, DSComp component) {
        new RootCausePrinter((Consumer)new Consumer<String>(){

            @Override
            public void accept(String str) {
                log.add(new ResultLog.Entry(Result.Status.OK, str.replaceFirst("    ", "-- ").replaceFirst("  ", "- ")));
            }
        }).print(component);
    }
}

