/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.base.internal.dispatch.FilterPipeline;
import org.apache.felix.http.base.internal.dispatch.NotFoundFilterChain;
import org.apache.felix.http.base.internal.dispatch.ServletPipeline;
import org.apache.felix.http.base.internal.handler.HandlerRegistry;

public final class Dispatcher {
    public static final String REQUEST_DISPATCHER_PROVIDER = "org.apache.felix.http.requestDispatcherProvider";
    private static final FilterChain DEFAULT_CHAIN = new NotFoundFilterChain();
    private final HandlerRegistry handlerRegistry;

    public Dispatcher(HandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletPipeline servletPipeline = new ServletPipeline(this.handlerRegistry.getServlets());
        req.setAttribute(REQUEST_DISPATCHER_PROVIDER, servletPipeline);
        try {
            new FilterPipeline(this.handlerRegistry.getFilters(), servletPipeline).dispatch(req, res, DEFAULT_CHAIN);
        }
        finally {
            req.removeAttribute(REQUEST_DISPATCHER_PROVIDER);
        }
    }
}

