/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.jetty.ConnectorFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ConnectorFactoryTracker
extends ServiceTracker {
    private final Server server;

    public ConnectorFactoryTracker(BundleContext context, Server server) {
        super(context, ConnectorFactory.class.getName(), null);
        this.server = server;
    }

    public void open() {
        if (!this.server.isStarted()) {
            throw new IllegalStateException("Jetty Server must be started before looking for ConnectorFactory services");
        }
        super.open();
    }

    public Object addingService(ServiceReference reference) {
        ConnectorFactory factory = (ConnectorFactory)super.addingService(reference);
        Connector connector = factory.createConnector(this.server);
        try {
            this.server.addConnector(connector);
            connector.start();
            return connector;
        }
        catch (Exception e) {
            SystemLogger.error("Failed starting connector '" + connector + "' provided by " + reference, e);
            return null;
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        Connector connector = (Connector)service;
        if (connector.isStarted()) {
            try {
                connector.stop();
            }
            catch (Exception e) {
                SystemLogger.info("Failed stopping connector '" + connector + "' provided by " + reference + ": " + e);
            }
        }
        this.server.removeConnector(connector);
    }
}

