/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.visitor;

import org.apache.felix.ipojo.manipulator.metadata.annotation.ComponentWorkbench;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

public class RequiresVisitor
extends AnnotationVisitor {
    private ComponentWorkbench workbench;
    private String m_field;
    private String m_filter;
    private String m_optional;
    private String m_specification;
    private String m_id;
    private String m_policy;
    private String m_defaultImplementation;
    private String m_exception;
    private String m_nullable;
    private String m_comparator;
    private String m_from;
    private String m_proxy;
    private String m_timeout;

    public RequiresVisitor(ComponentWorkbench workbench, String name) {
        super(327680);
        this.workbench = workbench;
        this.m_field = name;
    }

    @Override
    public void visit(String name, Object value) {
        if (name.equals("filter")) {
            this.m_filter = value.toString();
            return;
        }
        if (name.equals("optional")) {
            this.m_optional = value.toString();
            return;
        }
        if (name.equals("nullable")) {
            this.m_nullable = value.toString();
            return;
        }
        if (name.equals("policy")) {
            this.m_policy = RequiresVisitor.getPolicy(value.toString());
            return;
        }
        if (name.equals("defaultimplementation")) {
            Type type = Type.getType(value.toString());
            this.m_defaultImplementation = type.getClassName();
            return;
        }
        if (name.equals("exception")) {
            Type type = Type.getType(value.toString());
            this.m_exception = type.getClassName();
            return;
        }
        if (name.equals("specification")) {
            if (value.toString().startsWith("L") && value.toString().endsWith(";")) {
                Type type = Type.getType(value.toString());
                this.m_specification = type.getClassName();
            } else {
                this.m_specification = value.toString();
            }
            return;
        }
        if (name.equals("id")) {
            this.m_id = value.toString();
            return;
        }
        if (name.equals("comparator")) {
            Type type = Type.getType(value.toString());
            this.m_comparator = type.getClassName();
            return;
        }
        if (name.equals("from")) {
            this.m_from = value.toString();
            return;
        }
        if (name.equals("proxy")) {
            this.m_proxy = value.toString();
        }
        if (name.equals("timeout")) {
            this.m_timeout = value.toString();
        }
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        if (name.equals("policy")) {
            this.m_policy = RequiresVisitor.getPolicy(value);
        }
    }

    @Override
    public void visitEnd() {
        Element requires = this.m_id == null ? this.workbench.getIds().get(this.m_field) : this.workbench.getIds().get(this.m_id);
        if (requires == null) {
            requires = new Element("requires", "");
        }
        requires.addAttribute(new Attribute("field", this.m_field));
        if (this.m_specification != null) {
            requires.addAttribute(new Attribute("specification", this.m_specification));
        }
        if (this.m_filter != null) {
            requires.addAttribute(new Attribute("filter", this.m_filter));
        }
        if (this.m_optional != null) {
            requires.addAttribute(new Attribute("optional", this.m_optional));
        }
        if (this.m_nullable != null) {
            requires.addAttribute(new Attribute("nullable", this.m_nullable));
        }
        if (this.m_defaultImplementation != null) {
            requires.addAttribute(new Attribute("default-implementation", this.m_defaultImplementation));
        }
        if (this.m_exception != null) {
            requires.addAttribute(new Attribute("exception", this.m_exception));
        }
        if (this.m_policy != null) {
            requires.addAttribute(new Attribute("policy", this.m_policy));
        }
        if (this.m_id != null) {
            requires.addAttribute(new Attribute("id", this.m_id));
        }
        if (this.m_comparator != null) {
            requires.addAttribute(new Attribute("comparator", this.m_comparator));
        }
        if (this.m_from != null) {
            requires.addAttribute(new Attribute("from", this.m_from));
        }
        if (this.m_proxy != null) {
            requires.addAttribute(new Attribute("proxy", this.m_proxy));
        }
        if (this.m_timeout != null) {
            requires.addAttribute(new Attribute("timeout", this.m_timeout));
        }
        if (this.m_id != null) {
            this.workbench.getIds().put(this.m_id, requires);
        } else {
            this.workbench.getIds().put(this.m_field, requires);
        }
        this.workbench.getElements().put(requires, null);
    }

    public static String getPolicy(String policy) {
        if (policy.equalsIgnoreCase("static")) {
            return "static";
        }
        if (policy.equalsIgnoreCase("dynamic")) {
            return "dynamic";
        }
        if (policy.equalsIgnoreCase("dynamic_priority")) {
            return "dynamic-priority";
        }
        return policy;
    }
}

