/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic;

import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.FieldGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.MethodGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.ParameterGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.TypeGenericVisitor;
import org.apache.felix.ipojo.manipulator.spi.AnnotationVisitorFactory;
import org.apache.felix.ipojo.manipulator.spi.BindingContext;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;

public class GenericVisitorFactory
implements AnnotationVisitorFactory {
    private final String m_name;
    private final String m_namespace;

    public GenericVisitorFactory(String name, String namespace) {
        this.m_name = name;
        this.m_namespace = namespace;
    }

    @Override
    public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
        if (context.getClassNode() != null) {
            return new TypeGenericVisitor(context.getWorkbench(), new Element(this.m_name, this.m_namespace));
        }
        if (context.getFieldNode() != null) {
            return new FieldGenericVisitor(context.getWorkbench(), new Element(this.m_name, this.m_namespace), context.getFieldNode());
        }
        if (context.getMethodNode() != null && context.getParameterIndex() == -1) {
            return new MethodGenericVisitor(context.getWorkbench(), new Element(this.m_name, this.m_namespace), context.getMethodNode());
        }
        return new ParameterGenericVisitor(context.getWorkbench(), new Element(this.m_name, this.m_namespace), context.getMethodNode(), context.getParameterIndex());
    }

    public String toString() {
        return "GenericVisitorFactory";
    }
}

