/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.architecture;

import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceStateListener;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class InstanceDescription
implements InstanceStateListener {
    protected HandlerDescription[] m_handlers = new HandlerDescription[0];
    protected final ComponentInstance m_instance;
    protected final ComponentTypeDescription m_type;

    public InstanceDescription(ComponentTypeDescription desc, ComponentInstance ci) {
        this.m_type = desc;
        this.m_instance = ci;
        this.m_instance.addInstanceStateListener(this);
    }

    public ComponentInstance getInstance() {
        return this.m_instance;
    }

    public String getName() {
        return this.m_instance.getInstanceName();
    }

    public ComponentTypeDescription getComponentDescription() {
        return this.m_type;
    }

    public HandlerDescription[] getHandlers() {
        return this.m_handlers;
    }

    public void addHandler(HandlerDescription desc) {
        for (HandlerDescription handler : this.m_handlers) {
            if (handler != desc) continue;
            return;
        }
        HandlerDescription[] newHd = new HandlerDescription[this.m_handlers.length + 1];
        System.arraycopy(this.m_handlers, 0, newHd, 0, this.m_handlers.length);
        newHd[this.m_handlers.length] = desc;
        this.m_handlers = newHd;
    }

    public HandlerDescription getHandlerDescription(String handler) {
        for (HandlerDescription description : this.m_handlers) {
            if (!description.getHandlerName().equalsIgnoreCase(handler)) continue;
            return description;
        }
        return null;
    }

    public int getState() {
        this.waitForStability();
        return this.m_instance.getState();
    }

    public long getBundleId() {
        return this.m_instance.getFactory().getBundleContext().getBundle().getBundleId();
    }

    public Element getDescription() {
        Element instance = new Element("Instance", "");
        instance.addAttribute(new Attribute("name", this.getName()));
        int state = this.getState();
        if (state == 0) {
            instance.addAttribute(new Attribute("state", "stopped"));
        }
        if (state == 2) {
            instance.addAttribute(new Attribute("state", "valid"));
        }
        if (state == 1) {
            instance.addAttribute(new Attribute("state", "invalid"));
        }
        if (state == -1) {
            instance.addAttribute(new Attribute("state", "disposed"));
        }
        instance.addAttribute(new Attribute("bundle", Long.toString(this.getBundleId())));
        instance.addAttribute(new Attribute("component.type", this.m_type.getName()));
        for (HandlerDescription description : this.m_handlers) {
            instance.addElement(description.getHandlerInfo());
        }
        return instance;
    }

    private synchronized void waitForStability() {
        while (this.m_instance.getState() == -2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void stateChanged(ComponentInstance instance, int newState) {
        this.notifyAll();
    }
}

