/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.event.publisher;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.FieldInterceptor;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.handlers.event.publisher.EventAdminPublisherHandlerDescription;
import org.apache.felix.ipojo.handlers.event.publisher.EventAdminPublisherMetadata;
import org.apache.felix.ipojo.handlers.event.publisher.Publisher;
import org.apache.felix.ipojo.handlers.event.publisher.PublisherImpl;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.osgi.service.event.EventAdmin;

public class EventAdminPublisherHandler
extends PrimitiveHandler {
    public static final String NAMESPACE = "org.apache.felix.ipojo.handlers.event";
    public static final String TOPICS_PROPERTY = "event.topics";
    private static final String LOG_PREFIX = "EVENT ADMIN PUBLISHER HANDLER : ";
    private InstanceManager m_manager;
    private EventAdmin m_ea;
    private Map m_publishersByField = new Hashtable();
    private EventAdminPublisherHandlerDescription m_description;
    static /* synthetic */ Class class$java$util$Dictionary;
    static /* synthetic */ Class class$org$apache$felix$ipojo$handlers$event$publisher$Publisher;

    public void initializeComponentFactory(ComponentTypeDescription cd, Element metadata) throws ConfigurationException {
        Properties dict = new Properties();
        PropertyDescription pd = new PropertyDescription(TOPICS_PROPERTY, (class$java$util$Dictionary == null ? (class$java$util$Dictionary = EventAdminPublisherHandler.class$("java.util.Dictionary")) : class$java$util$Dictionary).getName(), ((Object)dict).toString());
        cd.addProperty(pd);
        Element[] publishers = metadata.getElements("publisher", NAMESPACE);
        if (publishers == null || publishers.length == 0) {
            publishers = metadata.getElements("publishes", NAMESPACE);
        }
        if (publishers != null) {
            HashSet<String> nameSet = new HashSet<String>();
            HashSet<String> fieldSet = new HashSet<String>();
            for (int i = 0; i < publishers.length; ++i) {
                EventAdminPublisherMetadata publisherMetadata = new EventAdminPublisherMetadata(publishers[i]);
                String name = publisherMetadata.getName();
                this.info("EVENT ADMIN PUBLISHER HANDLER : Checking publisher " + name);
                String field = publisherMetadata.getField();
                FieldMetadata fieldMetadata = this.getPojoMetadata().getField(publisherMetadata.getField(), (class$org$apache$felix$ipojo$handlers$event$publisher$Publisher == null ? EventAdminPublisherHandler.class$("org.apache.felix.ipojo.handlers.event.publisher.Publisher") : class$org$apache$felix$ipojo$handlers$event$publisher$Publisher).getName());
                if (fieldMetadata == null) {
                    throw new ConfigurationException("Field not found in the component : " + (class$org$apache$felix$ipojo$handlers$event$publisher$Publisher == null ? (class$org$apache$felix$ipojo$handlers$event$publisher$Publisher = EventAdminPublisherHandler.class$("org.apache.felix.ipojo.handlers.event.publisher.Publisher")) : class$org$apache$felix$ipojo$handlers$event$publisher$Publisher).getName() + " " + field);
                }
                if (nameSet.contains(name)) {
                    throw new ConfigurationException("A publisher with the same name already exists : " + name);
                }
                if (fieldSet.contains(field)) {
                    throw new ConfigurationException("The field " + field + " is already associated to a publisher");
                }
                nameSet.add(name);
                fieldSet.add(field);
            }
        } else {
            this.info("EVENT ADMIN PUBLISHER HANDLER : No publisher to check");
        }
    }

    public void configure(Element metadata, Dictionary conf) throws ConfigurationException {
        this.m_manager = this.getInstanceManager();
        Dictionary instanceTopics = (Dictionary)conf.get(TOPICS_PROPERTY);
        Element[] publishers = metadata.getElements("publisher", NAMESPACE);
        if (publishers == null || publishers.length == 0) {
            publishers = metadata.getElements("publishes", NAMESPACE);
        }
        if (publishers != null) {
            for (int i = 0; i < publishers.length; ++i) {
                String topicsString;
                EventAdminPublisherMetadata publisherMetadata = new EventAdminPublisherMetadata(publishers[i]);
                String name = publisherMetadata.getName();
                this.info("EVENT ADMIN PUBLISHER HANDLER : Configuring publisher " + name);
                String string = topicsString = instanceTopics != null ? (String)instanceTopics.get(name) : null;
                if (topicsString != null) {
                    publisherMetadata.setTopics(topicsString);
                }
                publisherMetadata.check();
                PublisherImpl publisher = new PublisherImpl(this, publisherMetadata.getTopics(), publisherMetadata.isSynchronous(), publisherMetadata.getDataKey(), this.m_manager.getInstanceName());
                this.m_publishersByField.put(publisherMetadata.getField(), publisher);
                FieldMetadata fieldMetadata = this.getPojoMetadata().getField(publisherMetadata.getField(), (class$org$apache$felix$ipojo$handlers$event$publisher$Publisher == null ? EventAdminPublisherHandler.class$("org.apache.felix.ipojo.handlers.event.publisher.Publisher") : class$org$apache$felix$ipojo$handlers$event$publisher$Publisher).getName());
                this.m_manager.register(fieldMetadata, (FieldInterceptor)this);
            }
        } else {
            this.info("EVENT ADMIN PUBLISHER HANDLER : No publisher to configure");
        }
        this.setValidity(true);
        this.debug("EVENT ADMIN PUBLISHER HANDLER : Setup description....");
        this.m_description = new EventAdminPublisherHandlerDescription((Handler)this, this.m_publishersByField.values());
    }

    public void start() {
    }

    public void stop() {
    }

    public Object onGet(Object pojo, String fieldName, Object value) {
        Publisher pub = (Publisher)this.m_publishersByField.get(fieldName);
        if (pub == null) {
            this.error("EVENT ADMIN PUBLISHER HANDLER : No publisher associated to the field " + fieldName);
        }
        return pub;
    }

    public EventAdmin getEventAdminService() {
        return this.m_ea;
    }

    public HandlerDescription getDescription() {
        return this.m_description;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

