/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.junit4osgi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.felix.ipojo.junit4osgi.Helper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class OSGiTestCase
extends TestCase {
    protected BundleContext context;
    private List m_references = new ArrayList();
    private List m_helpers = new ArrayList();

    public BundleContext getContext() {
        return this.context;
    }

    public void addHelper(Helper helper) {
        this.m_helpers.add(helper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        this.setUp();
        try {
            this.runTest();
        }
        finally {
            int i;
            this.tearDown();
            for (i = 0; i < this.m_helpers.size(); ++i) {
                ((Helper)this.m_helpers.get(i)).dispose();
            }
            for (i = 0; i < this.m_references.size(); ++i) {
                this.context.ungetService((ServiceReference)this.m_references.get(i));
            }
            this.m_references.clear();
        }
    }

    public void setBundleContext(BundleContext bc) {
        this.context = bc;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public static void assertContains(String message, String[] array, String txt) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(txt)) continue;
            return;
        }
        OSGiTestCase.fail(OSGiTestCase.formatContainsMessage(message, array, txt));
    }

    public static void assertContains(String message, byte[] array, int num) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != num) continue;
            return;
        }
        Object[] bytes = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            bytes[i] = new Byte(array[i]);
        }
        OSGiTestCase.fail(OSGiTestCase.formatContainsMessage(message, bytes, new Integer(num)));
    }

    public static void assertContains(String message, short[] array, int num) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != num) continue;
            return;
        }
        Object[] bytes = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            bytes[i] = new Short(array[i]);
        }
        OSGiTestCase.fail(OSGiTestCase.formatContainsMessage(message, bytes, new Integer(num)));
    }

    public static void assertContains(String message, int[] array, int num) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != num) continue;
            return;
        }
        Object[] bytes = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            bytes[i] = new Integer(array[i]);
        }
        OSGiTestCase.fail(OSGiTestCase.formatContainsMessage(message, bytes, new Integer(num)));
    }

    public static void assertContains(String message, long[] array, long num) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != num) continue;
            return;
        }
        Object[] bytes = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            bytes[i] = new Long(array[i]);
        }
        OSGiTestCase.fail(OSGiTestCase.formatContainsMessage(message, bytes, new Long(num)));
    }

    public static void assertContains(String message, float[] array, float num) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != num) continue;
            return;
        }
        Object[] bytes = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            bytes[i] = new Float(array[i]);
        }
        OSGiTestCase.fail(OSGiTestCase.formatContainsMessage(message, bytes, new Float(num)));
    }

    public static void assertContains(String message, double[] array, double num) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != num) continue;
            return;
        }
        Object[] bytes = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            bytes[i] = new Double(array[i]);
        }
        OSGiTestCase.fail(OSGiTestCase.formatContainsMessage(message, bytes, new Double(num)));
    }

    public static void assertContains(String message, char[] array, char character) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != character) continue;
            return;
        }
        Object[] bytes = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            bytes[i] = new Character(array[i]);
        }
        OSGiTestCase.fail(OSGiTestCase.formatContainsMessage(message, bytes, new Character(character)));
    }

    public static void assertEquals(String message, double expected, double actual) {
        if (expected != actual) {
            OSGiTestCase.fail(OSGiTestCase.formatEqualsMessage(message, new Double(expected), new Double(actual)));
        }
    }

    public static void assertNotEquals(String message, Object o1, Object o2) {
        if (o1.equals(o2)) {
            OSGiTestCase.fail(OSGiTestCase.formatNotEqualsMessage(message, o1, o2));
        }
    }

    public static boolean contains(String string, String[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            if (array[i] == null || !array[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int value, int[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    private static String formatEqualsMessage(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
    }

    private static String formatNotEqualsMessage(String message, Object o1, Object o2) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        return formatted + "o1:<" + o1 + "> is equals to o2:<" + o2 + ">";
    }

    private static String formatContainsMessage(String message, Object[] array, Object txt) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        String arr = null;
        for (int i = 0; i < array.length; ++i) {
            arr = arr == null ? "[" + array[i] : arr + "," + array[i];
        }
        arr = arr + "]";
        return formatted + "array:" + arr + " does not contains:<" + txt + ">";
    }

    public static Object getServiceObject(Bundle bundle, String itf, String filter) {
        ServiceReference ref = OSGiTestCase.getServiceReference(bundle, itf, filter);
        if (ref != null) {
            return bundle.getBundleContext().getService(ref);
        }
        return null;
    }

    public static Object[] getServiceObjects(Bundle bundle, String itf, String filter) {
        ServiceReference[] refs = OSGiTestCase.getServiceReferences(bundle, itf, filter);
        if (refs != null) {
            Object[] list = new Object[refs.length];
            for (int i = 0; i < refs.length; ++i) {
                list[i] = bundle.getBundleContext().getService(refs[i]);
            }
            return list;
        }
        return new Object[0];
    }

    public static ServiceReference getServiceReference(Bundle bundle, String itf, String filter) {
        ServiceReference[] refs = OSGiTestCase.getServiceReferences(bundle, itf, filter);
        if (refs.length != 0) {
            return refs[0];
        }
        return null;
    }

    public boolean isServiceAvailable(String itf) {
        ServiceReference ref = this.getServiceReference(itf, null);
        return ref != null;
    }

    public boolean isServiceAvailableByPID(String itf, String pid) {
        ServiceReference ref = this.getServiceReferenceByPID(itf, pid);
        return ref != null;
    }

    public static ServiceReference getServiceReferenceByPID(Bundle bundle, String itf, String pid) {
        String filter = "(service.pid=" + pid + ")";
        ServiceReference[] refs = OSGiTestCase.getServiceReferences(bundle, itf, filter);
        if (refs == null) {
            return null;
        }
        if (refs.length == 1) {
            return refs[0];
        }
        throw new IllegalStateException("A service lookup by PID returned several providers (" + refs.length + ")" + " for " + itf + " with pid=" + pid);
    }

    public static ServiceReference[] getServiceReferences(Bundle bundle, String itf, String filter) {
        ServiceReference[] refs = null;
        try {
            refs = bundle.getBundleContext().getServiceReferences(itf, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Cannot get service references: " + e.getMessage());
        }
        if (refs == null) {
            return new ServiceReference[0];
        }
        return refs;
    }

    public Object getServiceObject(String itf, String filter) {
        ServiceReference ref = this.getServiceReference(itf, filter);
        if (ref != null) {
            this.m_references.add(ref);
            return this.context.getService(ref);
        }
        return null;
    }

    public Object getServiceObject(ServiceReference ref) {
        if (ref != null) {
            this.m_references.add(ref);
            return this.context.getService(ref);
        }
        return null;
    }

    public Object[] getServiceObjects(String itf, String filter) {
        ServiceReference[] refs = this.getServiceReferences(itf, filter);
        if (refs != null) {
            Object[] list = new Object[refs.length];
            for (int i = 0; i < refs.length; ++i) {
                this.m_references.add(refs[i]);
                list[i] = this.context.getService(refs[i]);
            }
            return list;
        }
        return new Object[0];
    }

    public ServiceReference getServiceReference(String itf, String filter) {
        return OSGiTestCase.getServiceReference(this.context.getBundle(), itf, filter);
    }

    public ServiceReference getServiceReference(String itf) {
        return OSGiTestCase.getServiceReference(this.context.getBundle(), itf, null);
    }

    public ServiceReference getServiceReferenceByPID(String itf, String pid) {
        return OSGiTestCase.getServiceReferenceByPID(this.context.getBundle(), itf, pid);
    }

    public ServiceReference[] getServiceReferences(String itf, String filter) {
        return OSGiTestCase.getServiceReferences(this.context.getBundle(), itf, filter);
    }

    public PackageAdmin getPackageAdmin() {
        PackageAdmin pa = (PackageAdmin)this.getServiceObject(PackageAdmin.class.getName(), null);
        if (pa == null) {
            OSGiTestCase.fail("No package admin available");
        }
        return pa;
    }

    public void refresh() {
        this.getPackageAdmin().refreshPackages(null);
    }

    public void waitForService(String itf, String filter, long timeout) {
        if (timeout == 0L) {
            timeout = 10000L;
        }
        ServiceReference[] refs = this.getServiceReferences(itf, filter);
        long begin = System.currentTimeMillis();
        if (refs.length != 0) {
            return;
        }
        while (refs.length == 0) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long now = System.currentTimeMillis();
            if (now - begin > timeout) {
                OSGiTestCase.fail("Timeout ... no services matching with the request after " + timeout + "ms");
            }
            refs = this.getServiceReferences(itf, filter);
        }
    }

    public Bundle installBundle(String url) {
        try {
            return this.context.installBundle(url);
        }
        catch (BundleException e) {
            OSGiTestCase.fail("Cannot install the bundle " + url + " : " + e.getMessage());
            return null;
        }
    }

    public Bundle installBundle(String url, InputStream stream) {
        try {
            return this.context.installBundle(url, stream);
        }
        catch (BundleException e) {
            OSGiTestCase.fail("Cannot install the bundle " + url + " : " + e.getMessage());
            return null;
        }
    }

    public Bundle installAndStart(String url) {
        Bundle bundle = this.installBundle(url);
        try {
            bundle.start();
        }
        catch (BundleException e) {
            OSGiTestCase.fail("Cannot start the bundle " + url + " : " + e.getMessage());
        }
        return bundle;
    }

    public Bundle installAndStart(String url, InputStream stream) {
        Bundle bundle = this.installBundle(url, stream);
        try {
            bundle.start();
        }
        catch (BundleException e) {
            OSGiTestCase.fail("Cannot start the bundle " + url + " : " + e.getMessage());
        }
        return bundle;
    }

    public Bundle getBundle(long bundleId) {
        return this.context.getBundle(bundleId);
    }

    public Bundle getBundle(String name) {
        Bundle[] bundles = this.context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            if (!name.equals(bundles[i].getSymbolicName())) continue;
            return bundles[i];
        }
        OSGiTestCase.fail("No bundles with the given symbolic name " + name);
        return null;
    }
}

